/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.hpke;

import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.hpke.AEAD;
import com.enterprisedt.bouncycastle.crypto.hpke.b;

public class HPKEContext {
    protected final AEAD aead;
    protected final b hkdf;
    protected final byte[] exporterSecret;
    protected final byte[] suiteId;

    HPKEContext(AEAD aead, b hkdf, byte[] exporterSecret, byte[] suiteId) {
        this.aead = aead;
        this.hkdf = hkdf;
        this.exporterSecret = exporterSecret;
        this.suiteId = suiteId;
    }

    public byte[] export(byte[] exportContext, int L) {
        return this.hkdf.a(this.exporterSecret, this.suiteId, "sec", exportContext, L);
    }

    public byte[] seal(byte[] aad, byte[] message) throws InvalidCipherTextException {
        return this.aead.seal(aad, message);
    }

    public byte[] seal(byte[] aad, byte[] pt, int ptOffset, int ptLength) throws InvalidCipherTextException {
        return this.aead.seal(aad, pt, ptOffset, ptLength);
    }

    public byte[] open(byte[] aad, byte[] ct) throws InvalidCipherTextException {
        return this.aead.open(aad, ct);
    }

    public byte[] open(byte[] aad, byte[] ct, int ctOffset, int ctLength) throws InvalidCipherTextException {
        return this.aead.open(aad, ct, ctOffset, ctLength);
    }

    public byte[] extract(byte[] salt, byte[] ikm) {
        return this.hkdf.a(salt, ikm);
    }

    public byte[] expand(byte[] prk, byte[] info, int L) {
        return this.hkdf.a(prk, info, L);
    }
}

