/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.io;

import com.enterprisedt.bouncycastle.crypto.BufferedBlockCipher;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.SkippingCipher;
import com.enterprisedt.bouncycastle.crypto.StreamCipher;
import com.enterprisedt.bouncycastle.crypto.io.CipherIOException;
import com.enterprisedt.bouncycastle.crypto.io.InvalidCipherTextIOException;
import com.enterprisedt.bouncycastle.crypto.modes.AEADBlockCipher;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CipherInputStream
extends FilterInputStream {
    private SkippingCipher a;
    private byte[] b;
    private BufferedBlockCipher c;
    private StreamCipher d;
    private AEADBlockCipher e;
    private byte[] f;
    private byte[] g;
    private int h;
    private int i;
    private boolean j;
    private long k;
    private int l;

    public CipherInputStream(InputStream is, BufferedBlockCipher cipher) {
        this(is, cipher, 2048);
    }

    public CipherInputStream(InputStream is, StreamCipher cipher) {
        this(is, cipher, 2048);
    }

    public CipherInputStream(InputStream is, AEADBlockCipher cipher) {
        this(is, cipher, 2048);
    }

    public CipherInputStream(InputStream is, BufferedBlockCipher cipher, int bufSize) {
        super(is);
        this.c = cipher;
        this.b = new byte[bufSize];
        this.a = cipher instanceof SkippingCipher ? (SkippingCipher)((Object)cipher) : null;
    }

    public CipherInputStream(InputStream is, StreamCipher cipher, int bufSize) {
        super(is);
        this.d = cipher;
        this.b = new byte[bufSize];
        this.a = cipher instanceof SkippingCipher ? (SkippingCipher)((Object)cipher) : null;
    }

    public CipherInputStream(InputStream is, AEADBlockCipher cipher, int bufSize) {
        super(is);
        this.e = cipher;
        this.b = new byte[bufSize];
        this.a = cipher instanceof SkippingCipher ? (SkippingCipher)((Object)cipher) : null;
    }

    private int a() throws IOException {
        if (this.j) {
            return -1;
        }
        this.h = 0;
        this.i = 0;
        while (this.i == 0) {
            int n2 = this.in.read(this.b);
            if (n2 == -1) {
                this.b();
                if (this.i == 0) {
                    return -1;
                }
                return this.i;
            }
            try {
                this.a(n2, false);
                if (this.c != null) {
                    this.i = this.c.processBytes(this.b, 0, n2, this.f, 0);
                    continue;
                }
                if (this.e != null) {
                    this.i = this.e.processBytes(this.b, 0, n2, this.f, 0);
                    continue;
                }
                this.d.processBytes(this.b, 0, n2, this.f, 0);
                this.i = n2;
            }
            catch (Exception exception) {
                throw new CipherIOException("Error processing stream ", exception);
            }
        }
        return this.i;
    }

    private void b() throws IOException {
        try {
            this.j = true;
            this.a(0, true);
            this.i = this.c != null ? this.c.doFinal(this.f, 0) : (this.e != null ? this.e.doFinal(this.f, 0) : 0);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new InvalidCipherTextIOException("Error finalising cipher", invalidCipherTextException);
        }
        catch (Exception exception) {
            throw new IOException("Error finalising cipher " + exception);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.h >= this.i && this.a() < 0) {
            return -1;
        }
        return this.f[this.h++] & 0xFF;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        if (this.h >= this.i && this.a() < 0) {
            return -1;
        }
        int n2 = Math.min(len, this.available());
        System.arraycopy(this.f, this.h, b2, off, n2);
        this.h += n2;
        return n2;
    }

    @Override
    public long skip(long n2) throws IOException {
        if (n2 <= 0L) {
            return 0L;
        }
        if (this.a != null) {
            long l2;
            int n3 = this.available();
            if (n2 <= (long)n3) {
                this.h = (int)((long)this.h + n2);
                return n2;
            }
            this.h = this.i;
            long l3 = this.in.skip(n2 - (long)n3);
            if (l3 != (l2 = this.a.skip(l3))) {
                throw new IOException("Unable to skip cipher " + l3 + " bytes.");
            }
            return l3 + (long)n3;
        }
        int n4 = (int)Math.min(n2, (long)this.available());
        this.h += n4;
        return n4;
    }

    @Override
    public int available() throws IOException {
        return this.i - this.h;
    }

    private void a(int n2, boolean bl) {
        int n3 = n2;
        if (bl) {
            if (this.c != null) {
                n3 = this.c.getOutputSize(n2);
            } else if (this.e != null) {
                n3 = this.e.getOutputSize(n2);
            }
        } else if (this.c != null) {
            n3 = this.c.getUpdateOutputSize(n2);
        } else if (this.e != null) {
            n3 = this.e.getUpdateOutputSize(n2);
        }
        if (this.f == null || this.f.length < n3) {
            this.f = new byte[n3];
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            if (!this.j) {
                this.b();
            }
        }
        this.h = 0;
        this.i = 0;
        this.l = 0;
        this.k = 0L;
        if (this.g != null) {
            Arrays.fill(this.g, (byte)0);
            this.g = null;
        }
        if (this.f != null) {
            Arrays.fill(this.f, (byte)0);
            this.f = null;
        }
        Arrays.fill(this.b, (byte)0);
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
        if (this.a != null) {
            this.k = this.a.getPosition();
        }
        if (this.f != null) {
            this.g = new byte[this.f.length];
            System.arraycopy(this.f, 0, this.g, 0, this.f.length);
        }
        this.l = this.h;
    }

    @Override
    public void reset() throws IOException {
        if (this.a == null) {
            throw new IOException("cipher must implement SkippingCipher to be used with reset()");
        }
        this.in.reset();
        this.a.seekTo(this.k);
        if (this.g != null) {
            this.f = this.g;
        }
        this.h = this.l;
    }

    @Override
    public boolean markSupported() {
        if (this.a != null) {
            return this.in.markSupported();
        }
        return false;
    }
}

