/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.kems;

import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DerivationFunction;
import com.enterprisedt.bouncycastle.crypto.EncapsulatedSecretGenerator;
import com.enterprisedt.bouncycastle.crypto.SecretWithEncapsulation;
import com.enterprisedt.bouncycastle.crypto.constraints.ConstraintUtils;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.kems.a;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.KDFParameters;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECMultiplier;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECIESKEMGenerator
implements EncapsulatedSecretGenerator {
    private static final BigInteger a = BigInteger.valueOf(1L);
    private DerivationFunction b;
    private SecureRandom c;
    private final int d;
    private boolean e;
    private boolean f;
    private boolean g;

    public ECIESKEMGenerator(int keySize, DerivationFunction kdf, SecureRandom rnd) {
        this.d = keySize;
        this.b = kdf;
        this.c = rnd;
        this.e = false;
        this.f = false;
        this.g = false;
    }

    public ECIESKEMGenerator(int keyLen, DerivationFunction kdf, SecureRandom rnd, boolean cofactorMode, boolean oldCofactorMode, boolean singleHashMode) {
        this.b = kdf;
        this.c = rnd;
        this.d = keyLen;
        this.e = cofactorMode;
        this.f = cofactorMode ? false : oldCofactorMode;
        this.g = singleHashMode;
    }

    private ECMultiplier a() {
        return new FixedPointCombMultiplier();
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter recipientKey) {
        if (!(recipientKey instanceof ECKeyParameters)) {
            throw new IllegalArgumentException("EC key required");
        }
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)recipientKey;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("ECIESKem", ConstraintUtils.bitsOfSecurityFor(eCPublicKeyParameters.getParameters().getCurve()), recipientKey, CryptoServicePurpose.ENCRYPTION));
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        ECCurve eCCurve = eCDomainParameters.getCurve();
        BigInteger bigInteger = eCDomainParameters.getN();
        BigInteger bigInteger2 = eCDomainParameters.getH();
        BigInteger bigInteger3 = BigIntegers.createRandomInRange(a, bigInteger, this.c);
        BigInteger bigInteger4 = this.f ? bigInteger3.multiply(bigInteger2).mod(bigInteger) : bigInteger3;
        ECMultiplier eCMultiplier = this.a();
        ECPoint[] eCPointArray = new ECPoint[]{eCMultiplier.multiply(eCDomainParameters.getG(), bigInteger3), eCPublicKeyParameters.getQ().multiply(bigInteger4)};
        eCCurve.normalizeAll(eCPointArray);
        ECPoint eCPoint = eCPointArray[0];
        ECPoint eCPoint2 = eCPointArray[1];
        byte[] byArray = eCPoint.getEncoded(false);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byte[] byArray3 = eCPoint2.getAffineXCoord().getEncoded();
        return new a(ECIESKEMGenerator.a(this.g, this.b, this.d, byArray, byArray3), byArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] a(boolean bl, DerivationFunction derivationFunction, int n2, byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = byArray2;
        if (!bl) {
            byArray3 = Arrays.concatenate(byArray, byArray2);
            Arrays.fill(byArray2, (byte)0);
        }
        try {
            derivationFunction.init(new KDFParameters(byArray3, null));
            byte[] byArray4 = new byte[n2];
            derivationFunction.generateBytes(byArray4, 0, byArray4.length);
            byte[] byArray5 = byArray4;
            return byArray5;
        }
        finally {
            Arrays.fill(byArray3, (byte)0);
        }
    }
}

