/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.kems;

import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DerivationFunction;
import com.enterprisedt.bouncycastle.crypto.EncapsulatedSecretGenerator;
import com.enterprisedt.bouncycastle.crypto.SecretWithEncapsulation;
import com.enterprisedt.bouncycastle.crypto.constraints.ConstraintUtils;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.kems.a;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.KDFParameters;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSAKEMGenerator
implements EncapsulatedSecretGenerator {
    private static final BigInteger a = BigInteger.valueOf(0L);
    private static final BigInteger b = BigInteger.valueOf(1L);
    private final int c;
    private DerivationFunction d;
    private SecureRandom e;

    public RSAKEMGenerator(int keyLen, DerivationFunction kdf, SecureRandom rnd) {
        this.c = keyLen;
        this.d = kdf;
        this.e = rnd;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter recipientKey) {
        RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)recipientKey;
        if (rSAKeyParameters.isPrivate()) {
            throw new IllegalArgumentException("public key required for encryption");
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("RSAKem", ConstraintUtils.bitsOfSecurityFor(rSAKeyParameters.getModulus()), rSAKeyParameters, CryptoServicePurpose.ENCRYPTION));
        BigInteger bigInteger = rSAKeyParameters.getModulus();
        BigInteger bigInteger2 = rSAKeyParameters.getExponent();
        BigInteger bigInteger3 = BigIntegers.createRandomInRange(a, bigInteger.subtract(b), this.e);
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
        byte[] byArray = BigIntegers.asUnsignedByteArray((bigInteger.bitLength() + 7) / 8, bigInteger4);
        return new a(RSAKEMGenerator.a(this.d, bigInteger, bigInteger3, this.c), byArray);
    }

    static byte[] a(DerivationFunction derivationFunction, BigInteger bigInteger, BigInteger bigInteger2, int n2) {
        byte[] byArray = BigIntegers.asUnsignedByteArray((bigInteger.bitLength() + 7) / 8, bigInteger2);
        derivationFunction.init(new KDFParameters(byArray, null));
        byte[] byArray2 = new byte[n2];
        derivationFunction.generateBytes(byArray2, 0, byArray2.length);
        return byArray2;
    }
}

