/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.kems;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DerivationFunction;
import com.enterprisedt.bouncycastle.crypto.KeyEncapsulation;
import com.enterprisedt.bouncycastle.crypto.SecretWithEncapsulation;
import com.enterprisedt.bouncycastle.crypto.constraints.ConstraintUtils;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.kems.RSAKEMExtractor;
import com.enterprisedt.bouncycastle.crypto.kems.RSAKEMGenerator;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class RSAKeyEncapsulation
implements KeyEncapsulation {
    private DerivationFunction a;
    private SecureRandom b;
    private RSAKeyParameters c;

    public RSAKeyEncapsulation(DerivationFunction kdf, SecureRandom rnd) {
        this.a = kdf;
        this.b = rnd;
    }

    @Override
    public void init(CipherParameters key) throws IllegalArgumentException {
        if (!(key instanceof RSAKeyParameters)) {
            throw new IllegalArgumentException("RSA key required");
        }
        this.c = (RSAKeyParameters)key;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("RSAKem", ConstraintUtils.bitsOfSecurityFor(this.c.getModulus()), key, this.c.isPrivate() ? CryptoServicePurpose.DECRYPTION : CryptoServicePurpose.ENCRYPTION));
    }

    @Override
    public CipherParameters encrypt(byte[] out, int outOff, int keyLen) throws IllegalArgumentException {
        if (this.c.isPrivate()) {
            throw new IllegalArgumentException("Public key required for encryption");
        }
        RSAKEMGenerator rSAKEMGenerator = new RSAKEMGenerator(keyLen, this.a, this.b);
        SecretWithEncapsulation secretWithEncapsulation = rSAKEMGenerator.generateEncapsulated(this.c);
        byte[] byArray = secretWithEncapsulation.getEncapsulation();
        System.arraycopy(byArray, 0, out, outOff, byArray.length);
        return new KeyParameter(secretWithEncapsulation.getSecret());
    }

    public CipherParameters encrypt(byte[] out, int keyLen) {
        return this.encrypt(out, 0, keyLen);
    }

    @Override
    public CipherParameters decrypt(byte[] in, int inOff, int inLen, int keyLen) throws IllegalArgumentException {
        if (!this.c.isPrivate()) {
            throw new IllegalArgumentException("Private key required for decryption");
        }
        RSAKEMExtractor rSAKEMExtractor = new RSAKEMExtractor(this.c, keyLen, this.a);
        byte[] byArray = rSAKEMExtractor.extractSecret(Arrays.copyOfRange(in, inOff, inOff + inLen));
        return new KeyParameter(byArray);
    }

    public CipherParameters decrypt(byte[] in, int keyLen) {
        return this.decrypt(in, 0, in.length, keyLen);
    }
}

