/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.macs;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.digests.Blake3Digest;
import com.enterprisedt.bouncycastle.crypto.params.Blake3Parameters;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;

public class Blake3Mac
implements Mac {
    private final Blake3Digest a;

    public Blake3Mac(Blake3Digest pDigest) {
        this.a = pDigest;
    }

    @Override
    public String getAlgorithmName() {
        return this.a.getAlgorithmName() + "Mac";
    }

    @Override
    public void init(CipherParameters pParams) {
        CipherParameters cipherParameters = pParams;
        if (cipherParameters instanceof KeyParameter) {
            cipherParameters = Blake3Parameters.key(((KeyParameter)cipherParameters).getKey());
        }
        if (!(cipherParameters instanceof Blake3Parameters)) {
            throw new IllegalArgumentException("Invalid parameter passed to Blake3Mac init - " + pParams.getClass().getName());
        }
        Blake3Parameters blake3Parameters = (Blake3Parameters)cipherParameters;
        if (blake3Parameters.getKey() == null) {
            throw new IllegalArgumentException("Blake3Mac requires a key parameter.");
        }
        this.a.init(blake3Parameters);
    }

    @Override
    public int getMacSize() {
        return this.a.getDigestSize();
    }

    @Override
    public void update(byte in) {
        this.a.update(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.a.update(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        return this.a.doFinal(out, outOff);
    }

    @Override
    public void reset() {
        this.a.reset();
    }
}

