/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.macs;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithSBox;
import com.enterprisedt.bouncycastle.util.Pack;

public class GOST28147Mac
implements Mac {
    private final CryptoServicePurpose a;
    private int b;
    private byte[] c;
    private byte[] d;
    private boolean e = true;
    private int[] f = null;
    private byte[] g = null;
    private byte[] h = new byte[]{9, 6, 3, 2, 8, 11, 1, 7, 10, 4, 14, 15, 12, 0, 13, 5, 3, 7, 14, 9, 8, 10, 15, 0, 5, 2, 6, 12, 11, 4, 13, 1, 14, 4, 6, 2, 11, 3, 13, 8, 12, 15, 5, 10, 0, 7, 1, 9, 14, 7, 10, 12, 13, 1, 3, 9, 0, 2, 11, 4, 15, 8, 5, 6, 11, 5, 1, 9, 8, 13, 15, 0, 14, 4, 2, 3, 12, 7, 10, 6, 3, 10, 13, 12, 1, 2, 0, 11, 7, 5, 9, 4, 8, 15, 14, 6, 1, 13, 2, 9, 7, 10, 6, 0, 8, 12, 4, 5, 15, 3, 11, 14, 11, 10, 15, 5, 0, 12, 14, 8, 6, 2, 3, 9, 1, 7, 13, 4};

    public GOST28147Mac() {
        this(CryptoServicePurpose.AUTHENTICATION);
    }

    public GOST28147Mac(CryptoServicePurpose purpose) {
        this.a = purpose;
        this.d = new byte[8];
        this.c = new byte[8];
        this.b = 0;
    }

    private int[] a(byte[] byArray) {
        if (byArray.length != 32) {
            throw new IllegalArgumentException("Key length invalid. Key needs to be 32 byte - 256 bit!!!");
        }
        int[] nArray = new int[8];
        for (int i2 = 0; i2 != 8; ++i2) {
            nArray[i2] = Pack.littleEndianToInt(byArray, i2 * 4);
        }
        return nArray;
    }

    @Override
    public void init(CipherParameters params) throws IllegalArgumentException {
        this.reset();
        this.c = new byte[8];
        this.g = null;
        this.a(params);
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 178, params, this.a));
    }

    private void a(CipherParameters cipherParameters) throws IllegalArgumentException {
        if (cipherParameters == null) {
            return;
        }
        CipherParameters cipherParameters2 = null;
        if (cipherParameters instanceof ParametersWithSBox) {
            ParametersWithSBox parametersWithSBox = (ParametersWithSBox)cipherParameters;
            System.arraycopy(parametersWithSBox.getSBox(), 0, this.h, 0, parametersWithSBox.getSBox().length);
            cipherParameters2 = parametersWithSBox.getParameters();
        } else if (cipherParameters instanceof KeyParameter) {
            this.f = this.a(((KeyParameter)cipherParameters).getKey());
        } else if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            System.arraycopy(parametersWithIV.getIV(), 0, this.d, 0, this.d.length);
            this.g = parametersWithIV.getIV();
            cipherParameters2 = parametersWithIV.getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameter passed to GOST28147 init - " + cipherParameters.getClass().getName());
        }
        this.a(cipherParameters2);
    }

    @Override
    public String getAlgorithmName() {
        return "GOST28147Mac";
    }

    @Override
    public int getMacSize() {
        return 4;
    }

    private int a(int n2, int n3) {
        int n4 = n3 + n2;
        int n5 = this.h[0 + (n4 >> 0 & 0xF)] << 0;
        n5 += this.h[16 + (n4 >> 4 & 0xF)] << 4;
        n5 += this.h[32 + (n4 >> 8 & 0xF)] << 8;
        n5 += this.h[48 + (n4 >> 12 & 0xF)] << 12;
        n5 += this.h[64 + (n4 >> 16 & 0xF)] << 16;
        n5 += this.h[80 + (n4 >> 20 & 0xF)] << 20;
        n5 += this.h[96 + (n4 >> 24 & 0xF)] << 24;
        return (n5 += this.h[112 + (n4 >> 28 & 0xF)] << 28) << 11 | n5 >>> 21;
    }

    private void a(int[] nArray, byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4 = Pack.littleEndianToInt(byArray, n2);
        int n5 = Pack.littleEndianToInt(byArray, n2 + 4);
        for (int i2 = 0; i2 < 2; ++i2) {
            for (int i3 = 0; i3 < 8; ++i3) {
                int n6 = n4;
                n4 = n5 ^ this.a(n4, nArray[i3]);
                n5 = n6;
            }
        }
        Pack.intToLittleEndian(n4, byArray2, n3);
        Pack.intToLittleEndian(n5, byArray2, n3 + 4);
    }

    @Override
    public void update(byte in) throws IllegalStateException {
        if (this.b == this.c.length) {
            byte[] byArray = new byte[this.c.length];
            if (this.e) {
                this.e = false;
                if (this.g != null) {
                    GOST28147Mac.a(this.c, 0, this.g, byArray);
                } else {
                    System.arraycopy(this.c, 0, byArray, 0, this.d.length);
                }
            } else {
                GOST28147Mac.a(this.c, 0, this.d, byArray);
            }
            this.a(this.f, byArray, 0, this.d, 0);
            this.b = 0;
        }
        this.c[this.b++] = in;
    }

    @Override
    public void update(byte[] in, int inOff, int len) throws DataLengthException, IllegalStateException {
        if (len < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n2 = 8 - this.b;
        if (len > n2) {
            System.arraycopy(in, inOff, this.c, this.b, n2);
            byte[] byArray = new byte[this.c.length];
            if (this.e) {
                this.e = false;
                if (this.g != null) {
                    GOST28147Mac.a(this.c, 0, this.g, byArray);
                } else {
                    System.arraycopy(this.c, 0, byArray, 0, this.d.length);
                }
            } else {
                GOST28147Mac.a(this.c, 0, this.d, byArray);
            }
            this.a(this.f, byArray, 0, this.d, 0);
            this.b = 0;
            len -= n2;
            inOff += n2;
            while (len > 8) {
                GOST28147Mac.a(in, inOff, this.d, byArray);
                this.a(this.f, byArray, 0, this.d, 0);
                len -= 8;
                inOff += 8;
            }
        }
        System.arraycopy(in, inOff, this.c, this.b, len);
        this.b += len;
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        while (this.b < 8) {
            this.c[this.b] = 0;
            ++this.b;
        }
        byte[] byArray = new byte[this.c.length];
        if (this.e) {
            this.e = false;
            System.arraycopy(this.c, 0, byArray, 0, this.d.length);
        } else {
            GOST28147Mac.a(this.c, 0, this.d, byArray);
        }
        this.a(this.f, byArray, 0, this.d, 0);
        System.arraycopy(this.d, this.d.length / 2 - 4, out, outOff, 4);
        this.reset();
        return 4;
    }

    @Override
    public void reset() {
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            this.c[i2] = 0;
        }
        this.b = 0;
        this.e = true;
    }

    private static void a(byte[] byArray, int n2, byte[] byArray2, byte[] byArray3) {
        for (int i2 = 0; i2 < 8; ++i2) {
            byArray3[i2] = (byte)(byArray[n2 + i2] ^ byArray2[i2]);
        }
    }
}

