/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.macs;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.ExtendedDigest;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.util.Integers;
import com.enterprisedt.bouncycastle.util.Memoable;
import java.util.Hashtable;

public class HMac
implements Mac {
    private Digest a;
    private int b;
    private int c;
    private Memoable d;
    private Memoable e;
    private byte[] f;
    private byte[] g;
    private static Hashtable h = new Hashtable();

    private static int a(Digest digest) {
        if (digest instanceof ExtendedDigest) {
            return ((ExtendedDigest)digest).getByteLength();
        }
        Integer n2 = (Integer)h.get(digest.getAlgorithmName());
        if (n2 == null) {
            throw new IllegalArgumentException("unknown digest passed: " + digest.getAlgorithmName());
        }
        return n2;
    }

    public HMac(Digest digest) {
        this(digest, HMac.a(digest));
    }

    private HMac(Digest digest, int byteLength) {
        this.a = digest;
        this.b = digest.getDigestSize();
        this.c = byteLength;
        this.f = new byte[this.c];
        this.g = new byte[this.c + this.b];
    }

    @Override
    public String getAlgorithmName() {
        return this.a.getAlgorithmName() + "/HMAC";
    }

    public Digest getUnderlyingDigest() {
        return this.a;
    }

    @Override
    public void init(CipherParameters params) {
        this.a.reset();
        byte[] byArray = ((KeyParameter)params).getKey();
        int n2 = byArray.length;
        if (n2 > this.c) {
            this.a.update(byArray, 0, n2);
            this.a.doFinal(this.f, 0);
            n2 = this.b;
        } else {
            System.arraycopy(byArray, 0, this.f, 0, n2);
        }
        for (int i2 = n2; i2 < this.f.length; ++i2) {
            this.f[i2] = 0;
        }
        System.arraycopy(this.f, 0, this.g, 0, this.c);
        HMac.a(this.f, this.c, (byte)54);
        HMac.a(this.g, this.c, (byte)92);
        if (this.a instanceof Memoable) {
            this.e = ((Memoable)((Object)this.a)).copy();
            ((Digest)((Object)this.e)).update(this.g, 0, this.c);
        }
        this.a.update(this.f, 0, this.f.length);
        if (this.a instanceof Memoable) {
            this.d = ((Memoable)((Object)this.a)).copy();
        }
    }

    @Override
    public int getMacSize() {
        return this.b;
    }

    @Override
    public void update(byte in) {
        this.a.update(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.a.update(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        this.a.doFinal(this.g, this.c);
        if (this.e != null) {
            ((Memoable)((Object)this.a)).reset(this.e);
            this.a.update(this.g, this.c, this.a.getDigestSize());
        } else {
            this.a.update(this.g, 0, this.g.length);
        }
        int n2 = this.a.doFinal(out, outOff);
        for (int i2 = this.c; i2 < this.g.length; ++i2) {
            this.g[i2] = 0;
        }
        if (this.d != null) {
            ((Memoable)((Object)this.a)).reset(this.d);
        } else {
            this.a.update(this.f, 0, this.f.length);
        }
        return n2;
    }

    @Override
    public void reset() {
        if (this.d != null) {
            ((Memoable)((Object)this.a)).reset(this.d);
        } else {
            this.a.reset();
            this.a.update(this.f, 0, this.f.length);
        }
    }

    private static void a(byte[] byArray, int n2, byte by) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3++;
            byArray[n4] = (byte)(byArray[n4] ^ by);
        }
    }

    static {
        h.put("GOST3411", Integers.valueOf(32));
        h.put("MD2", Integers.valueOf(16));
        h.put("MD4", Integers.valueOf(64));
        h.put("MD5", Integers.valueOf(64));
        h.put("RIPEMD128", Integers.valueOf(64));
        h.put("RIPEMD160", Integers.valueOf(64));
        h.put("SHA-1", Integers.valueOf(64));
        h.put("SHA-224", Integers.valueOf(64));
        h.put("SHA-256", Integers.valueOf(64));
        h.put("SHA-384", Integers.valueOf(128));
        h.put("SHA-512", Integers.valueOf(128));
        h.put("Tiger", Integers.valueOf(64));
        h.put("Whirlpool", Integers.valueOf(64));
    }
}

