/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.macs;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Pack;

public class Poly1305
implements Mac {
    private final BlockCipher a;
    private final byte[] b = new byte[1];
    private int c;
    private int d;
    private int e;
    private int f;
    private int g;
    private int h;
    private int i;
    private int j;
    private int k;
    private int l;
    private int m;
    private int n;
    private int o;
    private final byte[] p = new byte[16];
    private int q = 0;
    private int r;
    private int s;
    private int t;
    private int u;
    private int v;

    public Poly1305() {
        this.a = null;
    }

    public Poly1305(BlockCipher cipher) {
        if (cipher.getBlockSize() != 16) {
            throw new IllegalArgumentException("Poly1305 requires a 128 bit block cipher.");
        }
        this.a = cipher;
    }

    @Override
    public void init(CipherParameters params) throws IllegalArgumentException {
        CipherParameters cipherParameters;
        byte[] byArray = null;
        if (this.a != null) {
            if (!(params instanceof ParametersWithIV)) {
                throw new IllegalArgumentException("Poly1305 requires an IV when used with a block cipher.");
            }
            cipherParameters = (ParametersWithIV)params;
            byArray = ((ParametersWithIV)cipherParameters).getIV();
            params = ((ParametersWithIV)cipherParameters).getParameters();
        }
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("Poly1305 requires a key.");
        }
        cipherParameters = (KeyParameter)params;
        this.a(((KeyParameter)cipherParameters).getKey(), byArray);
        this.reset();
    }

    private void a(byte[] byArray, byte[] byArray2) {
        int n2;
        byte[] byArray3;
        if (byArray.length != 32) {
            throw new IllegalArgumentException("Poly1305 key must be 256 bits.");
        }
        if (this.a != null && (byArray2 == null || byArray2.length != 16)) {
            throw new IllegalArgumentException("Poly1305 requires a 128 bit IV.");
        }
        int n3 = Pack.littleEndianToInt(byArray, 0);
        int n4 = Pack.littleEndianToInt(byArray, 4);
        int n5 = Pack.littleEndianToInt(byArray, 8);
        int n6 = Pack.littleEndianToInt(byArray, 12);
        this.c = n3 & 0x3FFFFFF;
        this.d = (n3 >>> 26 | n4 << 6) & 0x3FFFF03;
        this.e = (n4 >>> 20 | n5 << 12) & 0x3FFC0FF;
        this.f = (n5 >>> 14 | n6 << 18) & 0x3F03FFF;
        this.g = n6 >>> 8 & 0xFFFFF;
        this.h = this.d * 5;
        this.i = this.e * 5;
        this.j = this.f * 5;
        this.k = this.g * 5;
        if (this.a == null) {
            byArray3 = byArray;
            n2 = 16;
        } else {
            byArray3 = new byte[16];
            n2 = 0;
            this.a.init(true, new KeyParameter(byArray, 16, 16));
            this.a.processBlock(byArray2, 0, byArray3, 0);
        }
        this.l = Pack.littleEndianToInt(byArray3, n2 + 0);
        this.m = Pack.littleEndianToInt(byArray3, n2 + 4);
        this.n = Pack.littleEndianToInt(byArray3, n2 + 8);
        this.o = Pack.littleEndianToInt(byArray3, n2 + 12);
    }

    @Override
    public String getAlgorithmName() {
        return this.a == null ? "Poly1305" : "Poly1305-" + this.a.getAlgorithmName();
    }

    @Override
    public int getMacSize() {
        return 16;
    }

    @Override
    public void update(byte in) throws IllegalStateException {
        this.b[0] = in;
        this.update(this.b, 0, 1);
    }

    @Override
    public void update(byte[] in, int inOff, int len) throws DataLengthException, IllegalStateException {
        int n2 = 0;
        while (len > n2) {
            if (this.q == 16) {
                this.a();
                this.q = 0;
            }
            int n3 = Math.min(len - n2, 16 - this.q);
            System.arraycopy(in, n2 + inOff, this.p, this.q, n3);
            n2 += n3;
            this.q += n3;
        }
    }

    private void a() {
        if (this.q < 16) {
            this.p[this.q] = 1;
            for (int i2 = this.q + 1; i2 < 16; ++i2) {
                this.p[i2] = 0;
            }
        }
        long l2 = 0xFFFFFFFFL & (long)Pack.littleEndianToInt(this.p, 0);
        long l3 = 0xFFFFFFFFL & (long)Pack.littleEndianToInt(this.p, 4);
        long l4 = 0xFFFFFFFFL & (long)Pack.littleEndianToInt(this.p, 8);
        long l5 = 0xFFFFFFFFL & (long)Pack.littleEndianToInt(this.p, 12);
        this.r = (int)((long)this.r + (l2 & 0x3FFFFFFL));
        this.s = (int)((long)this.s + ((l3 << 32 | l2) >>> 26 & 0x3FFFFFFL));
        this.t = (int)((long)this.t + ((l4 << 32 | l3) >>> 20 & 0x3FFFFFFL));
        this.u = (int)((long)this.u + ((l5 << 32 | l4) >>> 14 & 0x3FFFFFFL));
        this.v = (int)((long)this.v + (l5 >>> 8));
        if (this.q == 16) {
            this.v += 0x1000000;
        }
        long l6 = Poly1305.a(this.r, this.c) + Poly1305.a(this.s, this.k) + Poly1305.a(this.t, this.j) + Poly1305.a(this.u, this.i) + Poly1305.a(this.v, this.h);
        long l7 = Poly1305.a(this.r, this.d) + Poly1305.a(this.s, this.c) + Poly1305.a(this.t, this.k) + Poly1305.a(this.u, this.j) + Poly1305.a(this.v, this.i);
        long l8 = Poly1305.a(this.r, this.e) + Poly1305.a(this.s, this.d) + Poly1305.a(this.t, this.c) + Poly1305.a(this.u, this.k) + Poly1305.a(this.v, this.j);
        long l9 = Poly1305.a(this.r, this.f) + Poly1305.a(this.s, this.e) + Poly1305.a(this.t, this.d) + Poly1305.a(this.u, this.c) + Poly1305.a(this.v, this.k);
        long l10 = Poly1305.a(this.r, this.g) + Poly1305.a(this.s, this.f) + Poly1305.a(this.t, this.e) + Poly1305.a(this.u, this.d) + Poly1305.a(this.v, this.c);
        this.r = (int)l6 & 0x3FFFFFF;
        this.s = (int)(l7 += l6 >>> 26) & 0x3FFFFFF;
        this.t = (int)(l8 += l7 >>> 26) & 0x3FFFFFF;
        this.u = (int)(l9 += l8 >>> 26) & 0x3FFFFFF;
        this.v = (int)(l10 += l9 >>> 26) & 0x3FFFFFF;
        this.r += (int)(l10 >>> 26) * 5;
        this.s += this.r >>> 26;
        this.r &= 0x3FFFFFF;
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (outOff + 16 > out.length) {
            throw new OutputLengthException("Output buffer is too short.");
        }
        if (this.q > 0) {
            this.a();
        }
        this.s += this.r >>> 26;
        this.r &= 0x3FFFFFF;
        this.t += this.s >>> 26;
        this.s &= 0x3FFFFFF;
        this.u += this.t >>> 26;
        this.t &= 0x3FFFFFF;
        this.v += this.u >>> 26;
        this.u &= 0x3FFFFFF;
        this.r += (this.v >>> 26) * 5;
        this.v &= 0x3FFFFFF;
        this.s += this.r >>> 26;
        this.r &= 0x3FFFFFF;
        int n2 = this.r + 5;
        int n3 = n2 >>> 26;
        n2 &= 0x3FFFFFF;
        int n4 = this.s + n3;
        n3 = n4 >>> 26;
        n4 &= 0x3FFFFFF;
        int n5 = this.t + n3;
        n3 = n5 >>> 26;
        n5 &= 0x3FFFFFF;
        int n6 = this.u + n3;
        n3 = n6 >>> 26;
        n6 &= 0x3FFFFFF;
        int n7 = this.v + n3 - 0x4000000;
        n3 = (n7 >>> 31) - 1;
        int n8 = ~n3;
        this.r = this.r & n8 | n2 & n3;
        this.s = this.s & n8 | n4 & n3;
        this.t = this.t & n8 | n5 & n3;
        this.u = this.u & n8 | n6 & n3;
        this.v = this.v & n8 | n7 & n3;
        long l2 = ((long)(this.r | this.s << 26) & 0xFFFFFFFFL) + (0xFFFFFFFFL & (long)this.l);
        long l3 = ((long)(this.s >>> 6 | this.t << 20) & 0xFFFFFFFFL) + (0xFFFFFFFFL & (long)this.m);
        long l4 = ((long)(this.t >>> 12 | this.u << 14) & 0xFFFFFFFFL) + (0xFFFFFFFFL & (long)this.n);
        long l5 = ((long)(this.u >>> 18 | this.v << 8) & 0xFFFFFFFFL) + (0xFFFFFFFFL & (long)this.o);
        Pack.intToLittleEndian((int)l2, out, outOff);
        Pack.intToLittleEndian((int)(l3 += l2 >>> 32), out, outOff + 4);
        Pack.intToLittleEndian((int)(l4 += l3 >>> 32), out, outOff + 8);
        Pack.intToLittleEndian((int)(l5 += l4 >>> 32), out, outOff + 12);
        this.reset();
        return 16;
    }

    @Override
    public void reset() {
        this.q = 0;
        this.v = 0;
        this.u = 0;
        this.t = 0;
        this.s = 0;
        this.r = 0;
    }

    private static final long a(int n2, int n3) {
        return ((long)n2 & 0xFFFFFFFFL) * (long)n3;
    }
}

