/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.macs;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.digests.SkeinEngine;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.SkeinParameters;

public class SkeinMac
implements Mac {
    public static final int SKEIN_256 = 256;
    public static final int SKEIN_512 = 512;
    public static final int SKEIN_1024 = 1024;
    private SkeinEngine a;

    public SkeinMac(int stateSizeBits, int digestSizeBits) {
        this.a = new SkeinEngine(stateSizeBits, digestSizeBits);
    }

    public SkeinMac(SkeinMac mac) {
        this.a = new SkeinEngine(mac.a);
    }

    @Override
    public String getAlgorithmName() {
        return "Skein-MAC-" + this.a.getBlockSize() * 8 + "-" + this.a.getOutputSize() * 8;
    }

    @Override
    public void init(CipherParameters params) throws IllegalArgumentException {
        SkeinParameters skeinParameters;
        if (params instanceof SkeinParameters) {
            skeinParameters = (SkeinParameters)params;
        } else if (params instanceof KeyParameter) {
            skeinParameters = new SkeinParameters.Builder().setKey(((KeyParameter)params).getKey()).build();
        } else {
            throw new IllegalArgumentException("Invalid parameter passed to Skein MAC init - " + params.getClass().getName());
        }
        if (skeinParameters.getKey() == null) {
            throw new IllegalArgumentException("Skein MAC requires a key parameter.");
        }
        this.a.init(skeinParameters);
    }

    @Override
    public int getMacSize() {
        return this.a.getOutputSize();
    }

    @Override
    public void reset() {
        this.a.reset();
    }

    @Override
    public void update(byte in) {
        this.a.update(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.a.update(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        return this.a.doFinal(out, outOff);
    }
}

