/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.StreamBlockCipher;
import com.enterprisedt.bouncycastle.crypto.modes.a;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Arrays;

public class G3413CFBBlockCipher
extends StreamBlockCipher {
    private final int a;
    private int b;
    private int c;
    private byte[] d;
    private byte[] e;
    private BlockCipher f;
    private boolean g;
    private boolean h = false;
    private byte[] i;
    private byte[] j;
    private int k;

    public G3413CFBBlockCipher(BlockCipher cipher) {
        this(cipher, cipher.getBlockSize() * 8);
    }

    public G3413CFBBlockCipher(BlockCipher cipher, int bitBlockSize) {
        super(cipher);
        if (bitBlockSize < 0 || bitBlockSize > cipher.getBlockSize() * 8) {
            throw new IllegalArgumentException("Parameter bitBlockSize must be in range 0 < bitBlockSize <= " + cipher.getBlockSize() * 8);
        }
        this.c = cipher.getBlockSize();
        this.f = cipher;
        this.a = bitBlockSize / 8;
        this.j = new byte[this.getBlockSize()];
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.g = forEncryption;
        if (params instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)params;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length < this.c) {
                throw new IllegalArgumentException("Parameter m must blockSize <= m");
            }
            this.b = byArray.length;
            this.b();
            this.e = Arrays.clone(byArray);
            System.arraycopy(this.e, 0, this.d, 0, this.e.length);
            if (parametersWithIV.getParameters() != null) {
                this.f.init(true, parametersWithIV.getParameters());
            }
        } else {
            this.c();
            this.b();
            System.arraycopy(this.e, 0, this.d, 0, this.e.length);
            if (params != null) {
                this.f.init(true, params);
            }
        }
        this.h = true;
    }

    private void b() {
        this.d = new byte[this.b];
        this.e = new byte[this.b];
    }

    private void c() {
        this.b = 2 * this.c;
    }

    @Override
    public String getAlgorithmName() {
        return this.f.getAlgorithmName() + "/CFB" + this.c * 8;
    }

    @Override
    public int getBlockSize() {
        return this.a;
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.processBytes(in, inOff, this.getBlockSize(), out, outOff);
        return this.getBlockSize();
    }

    @Override
    protected byte calculateByte(byte in) {
        if (this.k == 0) {
            this.i = this.a();
        }
        byte by = (byte)(this.i[this.k] ^ in);
        byte by2 = this.j[this.k++] = this.g ? by : in;
        if (this.k == this.getBlockSize()) {
            this.k = 0;
            this.a(this.j);
        }
        return by;
    }

    byte[] a() {
        byte[] byArray = com.enterprisedt.bouncycastle.crypto.modes.a.a(this.d, this.c);
        byte[] byArray2 = new byte[byArray.length];
        this.f.processBlock(byArray, 0, byArray2, 0);
        return com.enterprisedt.bouncycastle.crypto.modes.a.a(byArray2, this.a);
    }

    void a(byte[] byArray) {
        byte[] byArray2 = com.enterprisedt.bouncycastle.crypto.modes.a.b(this.d, this.b - this.a);
        System.arraycopy(byArray2, 0, this.d, 0, byArray2.length);
        System.arraycopy(byArray, 0, this.d, byArray2.length, this.b - byArray2.length);
    }

    @Override
    public void reset() {
        this.k = 0;
        Arrays.clear(this.j);
        Arrays.clear(this.i);
        if (this.h) {
            System.arraycopy(this.e, 0, this.d, 0, this.e.length);
            this.f.reset();
        }
    }
}

