/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.StreamBlockCipher;
import com.enterprisedt.bouncycastle.crypto.modes.CFBBlockCipher;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithSBox;

public class GCFBBlockCipher
extends StreamBlockCipher {
    private static final byte[] a = new byte[]{105, 0, 114, 34, 100, -55, 4, 35, -115, 58, -37, -106, 70, -23, 42, -60, 24, -2, -84, -108, 0, -19, 7, 18, -64, -122, -36, -62, -17, 76, -87, 43};
    private final CFBBlockCipher b;
    private KeyParameter c;
    private long d = 0L;
    private boolean e;

    public GCFBBlockCipher(BlockCipher engine) {
        super(engine);
        this.b = new CFBBlockCipher(engine, engine.getBlockSize() * 8);
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.d = 0L;
        this.b.init(forEncryption, params);
        this.e = forEncryption;
        if (params instanceof ParametersWithIV) {
            params = ((ParametersWithIV)params).getParameters();
        }
        if (params instanceof ParametersWithRandom) {
            params = ((ParametersWithRandom)params).getParameters();
        }
        if (params instanceof ParametersWithSBox) {
            params = ((ParametersWithSBox)params).getParameters();
        }
        this.c = (KeyParameter)params;
    }

    @Override
    public String getAlgorithmName() {
        String string = this.b.getAlgorithmName();
        return string.substring(0, string.indexOf(47)) + "/G" + string.substring(string.indexOf(47) + 1);
    }

    @Override
    public int getBlockSize() {
        return this.b.getBlockSize();
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.processBytes(in, inOff, this.b.getBlockSize(), out, outOff);
        return this.b.getBlockSize();
    }

    @Override
    protected byte calculateByte(byte b2) {
        if (this.d > 0L && this.d % 1024L == 0L) {
            BlockCipher blockCipher = this.b.getUnderlyingCipher();
            blockCipher.init(false, this.c);
            byte[] byArray = new byte[32];
            blockCipher.processBlock(a, 0, byArray, 0);
            blockCipher.processBlock(a, 8, byArray, 8);
            blockCipher.processBlock(a, 16, byArray, 16);
            blockCipher.processBlock(a, 24, byArray, 24);
            this.c = new KeyParameter(byArray);
            blockCipher.init(true, this.c);
            byte[] byArray2 = this.b.getCurrentIV();
            blockCipher.processBlock(byArray2, 0, byArray2, 0);
            this.b.init(this.e, new ParametersWithIV(this.c, byArray2));
        }
        ++this.d;
        return this.b.calculateByte(b2);
    }

    @Override
    public void reset() {
        this.d = 0L;
        this.b.reset();
    }
}

