/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.modes.AEADBlockCipher;
import com.enterprisedt.bouncycastle.crypto.params.AEADParameters;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;

public class KCCMBlockCipher
implements AEADBlockCipher {
    private BlockCipher a;
    private int b;
    private boolean c;
    private byte[] d;
    private byte[] e;
    private byte[] f;
    private byte[] g;
    private byte[] h;
    private byte[] i;
    private byte[] j;
    private byte[] k;
    private a l = new a();
    private a m = new a();
    private int n = 4;

    private void a(int n2) {
        if (n2 != 4 && n2 != 6 && n2 != 8) {
            throw new IllegalArgumentException("Nb = 4 is recommended by DSTU7624 but can be changed to only 6 or 8 in this implementation");
        }
        this.n = n2;
    }

    public KCCMBlockCipher(BlockCipher engine) {
        this(engine, 4);
    }

    public KCCMBlockCipher(BlockCipher engine, int nB) {
        this.a = engine;
        this.b = engine.getBlockSize();
        this.g = new byte[engine.getBlockSize()];
        this.d = new byte[engine.getBlockSize()];
        this.e = new byte[engine.getBlockSize()];
        this.f = new byte[engine.getBlockSize()];
        this.h = new byte[engine.getBlockSize()];
        this.i = new byte[engine.getBlockSize()];
        this.j = new byte[engine.getBlockSize()];
        this.k = new byte[engine.getBlockSize()];
        this.a(nB);
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        CipherParameters cipherParameters;
        if (params instanceof AEADParameters) {
            AEADParameters aEADParameters = (AEADParameters)params;
            if (aEADParameters.getMacSize() > 512 || aEADParameters.getMacSize() < 64 || aEADParameters.getMacSize() % 8 != 0) {
                throw new IllegalArgumentException("Invalid mac size specified");
            }
            this.g = aEADParameters.getNonce();
            this.b = aEADParameters.getMacSize() / 8;
            this.d = aEADParameters.getAssociatedText();
            cipherParameters = aEADParameters.getKey();
        } else if (params instanceof ParametersWithIV) {
            this.g = ((ParametersWithIV)params).getIV();
            this.b = this.a.getBlockSize();
            this.d = null;
            cipherParameters = ((ParametersWithIV)params).getParameters();
        } else {
            throw new IllegalArgumentException("Invalid parameters specified");
        }
        this.e = new byte[this.b];
        this.c = forEncryption;
        this.a.init(true, cipherParameters);
        this.k[0] = 1;
        if (this.d != null) {
            this.processAADBytes(this.d, 0, this.d.length);
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.a.getAlgorithmName() + "/KCCM";
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.a;
    }

    @Override
    public void processAADByte(byte in) {
        this.l.write(in);
    }

    @Override
    public void processAADBytes(byte[] in, int inOff, int len) {
        this.l.write(in, inOff, len);
    }

    private void a(byte[] byArray, int n2, int n3, int n4) {
        int n5;
        if (n3 - n2 < this.a.getBlockSize()) {
            throw new IllegalArgumentException("authText buffer too short");
        }
        if (n3 % this.a.getBlockSize() != 0) {
            throw new IllegalArgumentException("padding not supported");
        }
        System.arraycopy(this.g, 0, this.h, 0, this.g.length - this.n - 1);
        this.a(n4, this.i, 0);
        System.arraycopy(this.i, 0, this.h, this.g.length - this.n - 1, 4);
        this.h[this.h.length - 1] = this.a(true, this.b);
        this.a.processBlock(this.h, 0, this.f, 0);
        this.a(n3, this.i, 0);
        if (n3 <= this.a.getBlockSize() - this.n) {
            int n6;
            for (n6 = 0; n6 < n3; ++n6) {
                int n7 = n6 + this.n;
                this.i[n7] = (byte)(this.i[n7] ^ byArray[n2 + n6]);
            }
            for (n6 = 0; n6 < this.a.getBlockSize(); ++n6) {
                int n8 = n6;
                this.f[n8] = (byte)(this.f[n8] ^ this.i[n6]);
            }
            this.a.processBlock(this.f, 0, this.f, 0);
            return;
        }
        for (n5 = 0; n5 < this.a.getBlockSize(); ++n5) {
            int n9 = n5;
            this.f[n9] = (byte)(this.f[n9] ^ this.i[n5]);
        }
        this.a.processBlock(this.f, 0, this.f, 0);
        for (n5 = n3; n5 != 0; n5 -= this.a.getBlockSize()) {
            for (int i2 = 0; i2 < this.a.getBlockSize(); ++i2) {
                int n10 = i2;
                this.f[n10] = (byte)(this.f[n10] ^ byArray[i2 + n2]);
            }
            this.a.processBlock(this.f, 0, this.f, 0);
            n2 += this.a.getBlockSize();
        }
    }

    @Override
    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.m.write(in);
        return 0;
    }

    @Override
    public int processBytes(byte[] in, int inOff, int inLen, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (in.length < inOff + inLen) {
            throw new DataLengthException("input buffer too short");
        }
        this.m.write(in, inOff, inLen);
        return 0;
    }

    public int processPacket(byte[] in, int inOff, int len, byte[] out, int outOff) throws IllegalStateException, InvalidCipherTextException {
        int n2;
        if (in.length - inOff < len) {
            throw new DataLengthException("input buffer too short");
        }
        if (out.length - outOff < len) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this.l.size() > 0) {
            if (this.c) {
                this.a(this.l.a(), 0, this.l.size(), this.m.size());
            } else {
                this.a(this.l.a(), 0, this.l.size(), this.m.size() - this.b);
            }
        }
        if (this.c) {
            int n3;
            if (len % this.a.getBlockSize() != 0) {
                throw new DataLengthException("partial blocks not supported");
            }
            this.a(in, inOff, len);
            this.a.processBlock(this.g, 0, this.j, 0);
            int n4 = len;
            while (n4 > 0) {
                this.a(in, inOff, len, out, outOff);
                n4 -= this.a.getBlockSize();
                inOff += this.a.getBlockSize();
                outOff += this.a.getBlockSize();
            }
            for (n3 = 0; n3 < this.k.length; ++n3) {
                int n5 = n3;
                this.j[n5] = (byte)(this.j[n5] + this.k[n3]);
            }
            this.a.processBlock(this.j, 0, this.i, 0);
            for (n3 = 0; n3 < this.b; ++n3) {
                out[outOff + n3] = (byte)(this.i[n3] ^ this.f[n3]);
            }
            System.arraycopy(this.f, 0, this.e, 0, this.b);
            this.reset();
            return len + this.b;
        }
        if ((len - this.b) % this.a.getBlockSize() != 0) {
            throw new DataLengthException("partial blocks not supported");
        }
        this.a.processBlock(this.g, 0, this.j, 0);
        int n6 = len / this.a.getBlockSize();
        for (n2 = 0; n2 < n6; ++n2) {
            this.a(in, inOff, len, out, outOff);
            inOff += this.a.getBlockSize();
            outOff += this.a.getBlockSize();
        }
        if (len > inOff) {
            for (n2 = 0; n2 < this.k.length; ++n2) {
                int n7 = n2;
                this.j[n7] = (byte)(this.j[n7] + this.k[n2]);
            }
            this.a.processBlock(this.j, 0, this.i, 0);
            for (n2 = 0; n2 < this.b; ++n2) {
                out[outOff + n2] = (byte)(this.i[n2] ^ in[inOff + n2]);
            }
            outOff += this.b;
        }
        for (n2 = 0; n2 < this.k.length; ++n2) {
            int n8 = n2;
            this.j[n8] = (byte)(this.j[n8] + this.k[n2]);
        }
        this.a.processBlock(this.j, 0, this.i, 0);
        System.arraycopy(out, outOff - this.b, this.i, 0, this.b);
        this.a(out, 0, outOff - this.b);
        System.arraycopy(this.f, 0, this.e, 0, this.b);
        byte[] byArray = new byte[this.b];
        System.arraycopy(this.i, 0, byArray, 0, this.b);
        if (!Arrays.constantTimeAreEqual(this.e, byArray)) {
            throw new InvalidCipherTextException("mac check failed");
        }
        this.reset();
        return len - this.b;
    }

    private void a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        int n5;
        for (n5 = 0; n5 < this.k.length; ++n5) {
            int n6 = n5;
            this.j[n6] = (byte)(this.j[n6] + this.k[n5]);
        }
        this.a.processBlock(this.j, 0, this.i, 0);
        for (n5 = 0; n5 < this.a.getBlockSize(); ++n5) {
            byArray2[n4 + n5] = (byte)(this.i[n5] ^ byArray[n2 + n5]);
        }
    }

    private void a(byte[] byArray, int n2, int n3) {
        int n4 = n3;
        while (n4 > 0) {
            for (int i2 = 0; i2 < this.a.getBlockSize(); ++i2) {
                int n5 = i2;
                this.f[n5] = (byte)(this.f[n5] ^ byArray[n2 + i2]);
            }
            this.a.processBlock(this.f, 0, this.f, 0);
            n4 -= this.a.getBlockSize();
            n2 += this.a.getBlockSize();
        }
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws IllegalStateException, InvalidCipherTextException {
        int n2 = this.processPacket(this.m.a(), 0, this.m.size(), out, outOff);
        this.reset();
        return n2;
    }

    @Override
    public byte[] getMac() {
        return Arrays.clone(this.e);
    }

    @Override
    public int getUpdateOutputSize(int len) {
        return len;
    }

    @Override
    public int getOutputSize(int len) {
        return len + this.b;
    }

    @Override
    public void reset() {
        Arrays.fill(this.h, (byte)0);
        Arrays.fill(this.i, (byte)0);
        Arrays.fill(this.k, (byte)0);
        Arrays.fill(this.f, (byte)0);
        this.k[0] = 1;
        this.m.reset();
        this.l.reset();
        if (this.d != null) {
            this.processAADBytes(this.d, 0, this.d.length);
        }
    }

    private void a(int n2, byte[] byArray, int n3) {
        byArray[n3 + 3] = (byte)(n2 >> 24);
        byArray[n3 + 2] = (byte)(n2 >> 16);
        byArray[n3 + 1] = (byte)(n2 >> 8);
        byArray[n3] = (byte)n2;
    }

    private byte a(boolean bl, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        switch (n2) {
            case 8: {
                stringBuffer.append("010");
                break;
            }
            case 16: {
                stringBuffer.append("011");
                break;
            }
            case 32: {
                stringBuffer.append("100");
                break;
            }
            case 48: {
                stringBuffer.append("101");
                break;
            }
            case 64: {
                stringBuffer.append("110");
            }
        }
        String string = Integer.toBinaryString(this.n - 1);
        while (string.length() < 4) {
            string = new StringBuffer(string).insert(0, "0").toString();
        }
        stringBuffer.append(string);
        return (byte)Integer.parseInt(stringBuffer.toString(), 2);
    }

    private static class a
    extends ByteArrayOutputStream {
        public byte[] a() {
            return this.buf;
        }
    }
}

