/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.StreamBlockCipher;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Arrays;

public class KCTRBlockCipher
extends StreamBlockCipher {
    private byte[] a;
    private byte[] b;
    private byte[] c;
    private int d;
    private boolean e;
    private BlockCipher f;

    public KCTRBlockCipher(BlockCipher engine) {
        super(engine);
        this.f = engine;
        this.a = new byte[engine.getBlockSize()];
        this.b = new byte[engine.getBlockSize()];
        this.c = new byte[engine.getBlockSize()];
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.e = true;
        if (!(params instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("invalid parameter passed");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)params;
        byte[] byArray = parametersWithIV.getIV();
        int n2 = this.a.length - byArray.length;
        Arrays.fill(this.a, (byte)0);
        System.arraycopy(byArray, 0, this.a, n2, byArray.length);
        params = parametersWithIV.getParameters();
        if (params != null) {
            this.f.init(true, params);
        }
        this.reset();
    }

    @Override
    public String getAlgorithmName() {
        return this.f.getAlgorithmName() + "/KCTR";
    }

    @Override
    public int getBlockSize() {
        return this.f.getBlockSize();
    }

    @Override
    protected byte calculateByte(byte b2) {
        if (this.d == 0) {
            this.a(0);
            this.a();
            this.f.processBlock(this.b, 0, this.c, 0);
            return (byte)(this.c[this.d++] ^ b2);
        }
        byte by = (byte)(this.c[this.d++] ^ b2);
        if (this.d == this.b.length) {
            this.d = 0;
        }
        return by;
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (in.length - inOff < this.getBlockSize()) {
            throw new DataLengthException("input buffer too short");
        }
        if (out.length - outOff < this.getBlockSize()) {
            throw new OutputLengthException("output buffer too short");
        }
        this.processBytes(in, inOff, this.getBlockSize(), out, outOff);
        return this.getBlockSize();
    }

    @Override
    public void reset() {
        if (this.e) {
            this.f.processBlock(this.a, 0, this.b, 0);
        }
        this.f.reset();
        this.d = 0;
    }

    private void a(int n2) {
        int n3 = n2;
        while (n3 < this.b.length) {
            int n4 = n3++;
            this.b[n4] = (byte)(this.b[n4] + 1);
            if (this.b[n4] == 0) continue;
            break;
        }
    }

    private void a() {
    }
}

