/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.modes.AEADBlockCipher;
import com.enterprisedt.bouncycastle.crypto.params.AEADParameters;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Bytes;
import com.enterprisedt.bouncycastle.util.Longs;
import java.util.Vector;

public class OCBBlockCipher
implements AEADBlockCipher {
    private BlockCipher a;
    private BlockCipher b;
    private boolean c;
    private int d;
    private byte[] e;
    private Vector f;
    private byte[] g;
    private byte[] h;
    private byte[] i = null;
    private byte[] j = new byte[24];
    private byte[] k = new byte[16];
    private byte[] l;
    private byte[] m;
    private int n;
    private int o;
    private long p;
    private long q;
    private byte[] r;
    private byte[] s;
    private byte[] t = new byte[16];
    private byte[] u;
    private byte[] v;

    public OCBBlockCipher(BlockCipher hashCipher, BlockCipher mainCipher) {
        if (hashCipher == null) {
            throw new IllegalArgumentException("'hashCipher' cannot be null");
        }
        if (hashCipher.getBlockSize() != 16) {
            throw new IllegalArgumentException("'hashCipher' must have a block size of 16");
        }
        if (mainCipher == null) {
            throw new IllegalArgumentException("'mainCipher' cannot be null");
        }
        if (mainCipher.getBlockSize() != 16) {
            throw new IllegalArgumentException("'mainCipher' must have a block size of 16");
        }
        if (!hashCipher.getAlgorithmName().equals(mainCipher.getAlgorithmName())) {
            throw new IllegalArgumentException("'hashCipher' and 'mainCipher' must be the same algorithm");
        }
        this.a = hashCipher;
        this.b = mainCipher;
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.b;
    }

    @Override
    public String getAlgorithmName() {
        return this.b.getAlgorithmName() + "/OCB";
    }

    @Override
    public void init(boolean forEncryption, CipherParameters parameters) throws IllegalArgumentException {
        KeyParameter keyParameter;
        int n2;
        byte[] byArray;
        CipherParameters cipherParameters;
        boolean bl = this.c;
        this.c = forEncryption;
        this.v = null;
        if (parameters instanceof AEADParameters) {
            cipherParameters = (AEADParameters)parameters;
            byArray = ((AEADParameters)cipherParameters).getNonce();
            this.e = ((AEADParameters)cipherParameters).getAssociatedText();
            n2 = ((AEADParameters)cipherParameters).getMacSize();
            if (n2 < 64 || n2 > 128 || n2 % 8 != 0) {
                throw new IllegalArgumentException("Invalid value for MAC size: " + n2);
            }
            this.d = n2 / 8;
            keyParameter = ((AEADParameters)cipherParameters).getKey();
        } else if (parameters instanceof ParametersWithIV) {
            cipherParameters = (ParametersWithIV)parameters;
            byArray = ((ParametersWithIV)cipherParameters).getIV();
            this.e = null;
            this.d = 16;
            keyParameter = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to OCB");
        }
        this.l = new byte[16];
        this.m = new byte[forEncryption ? 16 : 16 + this.d];
        if (byArray == null) {
            byArray = new byte[]{};
        }
        if (byArray.length > 15) {
            throw new IllegalArgumentException("IV must be no more than 15 bytes");
        }
        if (keyParameter != null) {
            this.a.init(true, keyParameter);
            this.b.init(forEncryption, keyParameter);
            this.i = null;
        } else if (bl != forEncryption) {
            throw new IllegalArgumentException("cannot change encrypting state without providing key.");
        }
        this.g = new byte[16];
        this.a.processBlock(this.g, 0, this.g, 0);
        this.h = OCBBlockCipher.OCB_double(this.g);
        this.f = new Vector();
        this.f.addElement(OCBBlockCipher.OCB_double(this.h));
        int n3 = this.processNonce(byArray);
        n2 = n3 % 8;
        int n4 = n3 / 8;
        if (n2 == 0) {
            System.arraycopy(this.j, n4, this.k, 0, 16);
        } else {
            for (int i2 = 0; i2 < 16; ++i2) {
                int n5 = this.j[n4] & 0xFF;
                int n6 = this.j[++n4] & 0xFF;
                this.k[i2] = (byte)(n5 << n2 | n6 >>> 8 - n2);
            }
        }
        this.n = 0;
        this.o = 0;
        this.p = 0L;
        this.q = 0L;
        this.r = new byte[16];
        this.s = new byte[16];
        System.arraycopy(this.k, 0, this.t, 0, 16);
        this.u = new byte[16];
        if (this.e != null) {
            this.processAADBytes(this.e, 0, this.e.length);
        }
    }

    protected int processNonce(byte[] N) {
        byte[] byArray = new byte[16];
        System.arraycopy(N, 0, byArray, byArray.length - N.length, N.length);
        byArray[0] = (byte)(this.d << 4);
        int n2 = 15 - N.length;
        byArray[n2] = (byte)(byArray[n2] | 1);
        int n3 = byArray[15] & 0x3F;
        byArray[15] = (byte)(byArray[15] & 0xC0);
        if (this.i == null || !Arrays.areEqual(byArray, this.i)) {
            byte[] byArray2 = new byte[16];
            this.i = byArray;
            this.a.processBlock(this.i, 0, byArray2, 0);
            System.arraycopy(byArray2, 0, this.j, 0, 16);
            for (int i2 = 0; i2 < 8; ++i2) {
                this.j[16 + i2] = (byte)(byArray2[i2] ^ byArray2[i2 + 1]);
            }
        }
        return n3;
    }

    @Override
    public byte[] getMac() {
        if (this.v == null) {
            return new byte[this.d];
        }
        return Arrays.clone(this.v);
    }

    @Override
    public int getOutputSize(int len) {
        int n2 = len + this.o;
        if (this.c) {
            return n2 + this.d;
        }
        return n2 < this.d ? 0 : n2 - this.d;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        int n2 = len + this.o;
        if (!this.c) {
            if (n2 < this.d) {
                return 0;
            }
            n2 -= this.d;
        }
        return n2 - n2 % 16;
    }

    @Override
    public void processAADByte(byte input) {
        this.l[this.n] = input;
        if (++this.n == this.l.length) {
            this.processHashBlock();
        }
    }

    @Override
    public void processAADBytes(byte[] input, int off, int len) {
        for (int i2 = 0; i2 < len; ++i2) {
            this.l[this.n] = input[off + i2];
            if (++this.n != this.l.length) continue;
            this.processHashBlock();
        }
    }

    @Override
    public int processByte(byte input, byte[] output, int outOff) throws DataLengthException {
        this.m[this.o] = input;
        if (++this.o == this.m.length) {
            this.processMainBlock(output, outOff);
            return 16;
        }
        return 0;
    }

    @Override
    public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) throws DataLengthException {
        if (input.length < inOff + len) {
            throw new DataLengthException("Input buffer too short");
        }
        int n2 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            this.m[this.o] = input[inOff + i2];
            if (++this.o != this.m.length) continue;
            this.processMainBlock(output, outOff + n2);
            n2 += 16;
        }
        return n2;
    }

    @Override
    public int doFinal(byte[] output, int outOff) throws IllegalStateException, InvalidCipherTextException {
        byte[] byArray = null;
        if (!this.c) {
            if (this.o < this.d) {
                throw new InvalidCipherTextException("data too short");
            }
            this.o -= this.d;
            byArray = new byte[this.d];
            System.arraycopy(this.m, this.o, byArray, 0, this.d);
        }
        if (this.n > 0) {
            OCBBlockCipher.OCB_extend(this.l, this.n);
            this.updateHASH(this.g);
        }
        if (this.o > 0) {
            if (this.c) {
                OCBBlockCipher.OCB_extend(this.m, this.o);
                OCBBlockCipher.xor(this.u, this.m);
            }
            OCBBlockCipher.xor(this.t, this.g);
            byte[] byArray2 = new byte[16];
            this.a.processBlock(this.t, 0, byArray2, 0);
            OCBBlockCipher.xor(this.m, byArray2);
            if (output.length < outOff + this.o) {
                throw new OutputLengthException("Output buffer too short");
            }
            System.arraycopy(this.m, 0, output, outOff, this.o);
            if (!this.c) {
                OCBBlockCipher.OCB_extend(this.m, this.o);
                OCBBlockCipher.xor(this.u, this.m);
            }
        }
        OCBBlockCipher.xor(this.u, this.t);
        OCBBlockCipher.xor(this.u, this.h);
        this.a.processBlock(this.u, 0, this.u, 0);
        OCBBlockCipher.xor(this.u, this.s);
        this.v = new byte[this.d];
        System.arraycopy(this.u, 0, this.v, 0, this.d);
        int n2 = this.o;
        if (this.c) {
            if (output.length < outOff + n2 + this.d) {
                throw new OutputLengthException("Output buffer too short");
            }
            System.arraycopy(this.v, 0, output, outOff + n2, this.d);
            n2 += this.d;
        } else if (!Arrays.constantTimeAreEqual(this.v, byArray)) {
            throw new InvalidCipherTextException("mac check in OCB failed");
        }
        this.reset(false);
        return n2;
    }

    @Override
    public void reset() {
        this.reset(true);
    }

    protected void clear(byte[] bs) {
        if (bs != null) {
            Arrays.fill(bs, (byte)0);
        }
    }

    protected byte[] getLSub(int n2) {
        while (n2 >= this.f.size()) {
            this.f.addElement(OCBBlockCipher.OCB_double((byte[])this.f.lastElement()));
        }
        return (byte[])this.f.elementAt(n2);
    }

    protected void processHashBlock() {
        this.updateHASH(this.getLSub(OCBBlockCipher.OCB_ntz(++this.p)));
        this.n = 0;
    }

    protected void processMainBlock(byte[] output, int outOff) {
        if (output.length < outOff + 16) {
            throw new OutputLengthException("Output buffer too short");
        }
        if (this.c) {
            OCBBlockCipher.xor(this.u, this.m);
            this.o = 0;
        }
        OCBBlockCipher.xor(this.t, this.getLSub(OCBBlockCipher.OCB_ntz(++this.q)));
        OCBBlockCipher.xor(this.m, this.t);
        this.b.processBlock(this.m, 0, this.m, 0);
        OCBBlockCipher.xor(this.m, this.t);
        System.arraycopy(this.m, 0, output, outOff, 16);
        if (!this.c) {
            OCBBlockCipher.xor(this.u, this.m);
            System.arraycopy(this.m, 16, this.m, 0, this.d);
            this.o = this.d;
        }
    }

    protected void reset(boolean clearMac) {
        this.a.reset();
        this.b.reset();
        this.clear(this.l);
        this.clear(this.m);
        this.n = 0;
        this.o = 0;
        this.p = 0L;
        this.q = 0L;
        this.clear(this.r);
        this.clear(this.s);
        System.arraycopy(this.k, 0, this.t, 0, 16);
        this.clear(this.u);
        if (clearMac) {
            this.v = null;
        }
        if (this.e != null) {
            this.processAADBytes(this.e, 0, this.e.length);
        }
    }

    protected void updateHASH(byte[] LSub) {
        OCBBlockCipher.xor(this.r, LSub);
        OCBBlockCipher.xor(this.l, this.r);
        this.a.processBlock(this.l, 0, this.l, 0);
        OCBBlockCipher.xor(this.s, this.l);
    }

    protected static byte[] OCB_double(byte[] block) {
        byte[] byArray = new byte[16];
        int n2 = OCBBlockCipher.shiftLeft(block, byArray);
        byArray[15] = (byte)(byArray[15] ^ 135 >>> (1 - n2 << 3));
        return byArray;
    }

    protected static void OCB_extend(byte[] block, int pos) {
        block[pos] = -128;
        while (++pos < 16) {
            block[pos] = 0;
        }
    }

    protected static int OCB_ntz(long x) {
        return Longs.numberOfTrailingZeros(x);
    }

    protected static int shiftLeft(byte[] block, byte[] output) {
        int n2 = 16;
        int n3 = 0;
        while (--n2 >= 0) {
            int n4 = block[n2] & 0xFF;
            output[n2] = (byte)(n4 << 1 | n3);
            n3 = n4 >>> 7 & 1;
        }
        return n3;
    }

    protected static void xor(byte[] block, byte[] val) {
        Bytes.xorTo(16, val, block);
    }
}

