/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;

public class OpenPGPCFBBlockCipher
implements BlockCipher {
    private byte[] a;
    private byte[] b;
    private byte[] c;
    private BlockCipher d;
    private int e;
    private int f;
    private boolean g;

    public OpenPGPCFBBlockCipher(BlockCipher cipher) {
        this.d = cipher;
        this.f = cipher.getBlockSize();
        this.a = new byte[this.f];
        this.b = new byte[this.f];
        this.c = new byte[this.f];
    }

    public BlockCipher getUnderlyingCipher() {
        return this.d;
    }

    @Override
    public String getAlgorithmName() {
        return this.d.getAlgorithmName() + "/OpenPGPCFB";
    }

    @Override
    public int getBlockSize() {
        return this.d.getBlockSize();
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        return this.g ? this.a(in, inOff, out, outOff) : this.b(in, inOff, out, outOff);
    }

    @Override
    public void reset() {
        this.e = 0;
        System.arraycopy(this.a, 0, this.b, 0, this.b.length);
        this.d.reset();
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.g = forEncryption;
        this.reset();
        this.d.init(true, params);
    }

    private byte a(byte by, int n2) {
        return (byte)(this.c[n2] ^ by);
    }

    private int a(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        if (n2 + this.f > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n3 + this.f > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this.e > this.f) {
            this.b[this.f - 2] = byArray2[n3] = this.a(byArray[n2], this.f - 2);
            byte by = this.a(byArray[n2 + 1], this.f - 1);
            byArray2[n3 + 1] = by;
            this.b[this.f - 1] = by;
            this.d.processBlock(this.b, 0, this.c, 0);
            for (int i2 = 2; i2 < this.f; ++i2) {
                byte by2 = this.a(byArray[n2 + i2], i2 - 2);
                byArray2[n3 + i2] = by2;
                this.b[i2 - 2] = by2;
            }
        } else if (this.e == 0) {
            this.d.processBlock(this.b, 0, this.c, 0);
            for (int i3 = 0; i3 < this.f; ++i3) {
                byte by = this.a(byArray[n2 + i3], i3);
                byArray2[n3 + i3] = by;
                this.b[i3] = by;
            }
            this.e += this.f;
        } else if (this.e == this.f) {
            this.d.processBlock(this.b, 0, this.c, 0);
            byArray2[n3] = this.a(byArray[n2], 0);
            byArray2[n3 + 1] = this.a(byArray[n2 + 1], 1);
            System.arraycopy(this.b, 2, this.b, 0, this.f - 2);
            System.arraycopy(byArray2, n3, this.b, this.f - 2, 2);
            this.d.processBlock(this.b, 0, this.c, 0);
            for (int i4 = 2; i4 < this.f; ++i4) {
                byte by = this.a(byArray[n2 + i4], i4 - 2);
                byArray2[n3 + i4] = by;
                this.b[i4 - 2] = by;
            }
            this.e += this.f;
        }
        return this.f;
    }

    private int b(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        if (n2 + this.f > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n3 + this.f > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this.e > this.f) {
            byte by;
            this.b[this.f - 2] = by = byArray[n2];
            byArray2[n3] = this.a(by, this.f - 2);
            this.b[this.f - 1] = by = byArray[n2 + 1];
            byArray2[n3 + 1] = this.a(by, this.f - 1);
            this.d.processBlock(this.b, 0, this.c, 0);
            for (int i2 = 2; i2 < this.f; ++i2) {
                this.b[i2 - 2] = by = byArray[n2 + i2];
                byArray2[n3 + i2] = this.a(by, i2 - 2);
            }
        } else if (this.e == 0) {
            this.d.processBlock(this.b, 0, this.c, 0);
            for (int i3 = 0; i3 < this.f; ++i3) {
                this.b[i3] = byArray[n2 + i3];
                byArray2[n3 + i3] = this.a(byArray[n2 + i3], i3);
            }
            this.e += this.f;
        } else if (this.e == this.f) {
            this.d.processBlock(this.b, 0, this.c, 0);
            byte by = byArray[n2];
            byte by2 = byArray[n2 + 1];
            byArray2[n3] = this.a(by, 0);
            byArray2[n3 + 1] = this.a(by2, 1);
            System.arraycopy(this.b, 2, this.b, 0, this.f - 2);
            this.b[this.f - 2] = by;
            this.b[this.f - 1] = by2;
            this.d.processBlock(this.b, 0, this.c, 0);
            for (int i4 = 2; i4 < this.f; ++i4) {
                byte by3;
                this.b[i4 - 2] = by3 = byArray[n2 + i4];
                byArray2[n3 + i4] = this.a(by3, i4 - 2);
            }
            this.e += this.f;
        }
        return this.f;
    }
}

