/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.paddings;

import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class PKCS7Padding
implements BlockCipherPadding {
    @Override
    public void init(SecureRandom random) throws IllegalArgumentException {
    }

    @Override
    public String getPaddingName() {
        return "PKCS7";
    }

    @Override
    public int addPadding(byte[] in, int inOff) {
        byte by = (byte)(in.length - inOff);
        while (inOff < in.length) {
            in[inOff] = by;
            ++inOff;
        }
        return by;
    }

    @Override
    public int padCount(byte[] in) throws InvalidCipherTextException {
        byte by = in[in.length - 1];
        int n2 = by & 0xFF;
        int n3 = in.length - n2;
        int n4 = (n3 | n2 - 1) >> 31;
        for (int i2 = 0; i2 < in.length; ++i2) {
            n4 |= (in[i2] ^ by) & ~(i2 - n3 >> 31);
        }
        if (n4 != 0) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return n2;
    }
}

