/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.paddings;

import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class TBCPadding
implements BlockCipherPadding {
    @Override
    public void init(SecureRandom random) throws IllegalArgumentException {
    }

    @Override
    public String getPaddingName() {
        return "TBC";
    }

    @Override
    public int addPadding(byte[] in, int inOff) {
        int n2 = in.length - inOff;
        byte by = inOff > 0 ? (byte)((in[inOff - 1] & 1) == 0 ? 255 : 0) : (byte)((in[in.length - 1] & 1) == 0 ? 255 : 0);
        while (inOff < in.length) {
            in[inOff] = by;
            ++inOff;
        }
        return n2;
    }

    @Override
    public int padCount(byte[] in) throws InvalidCipherTextException {
        int n2 = in.length;
        int n3 = in[--n2] & 0xFF;
        int n4 = 1;
        int n5 = -1;
        while (--n2 >= 0) {
            int n6 = in[n2] & 0xFF;
            int n7 = (n6 ^ n3) - 1 >> 31;
            n4 -= (n5 &= n7);
        }
        return n4;
    }
}

