/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.paddings;

import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class X923Padding
implements BlockCipherPadding {
    SecureRandom a = null;

    @Override
    public void init(SecureRandom random) throws IllegalArgumentException {
        this.a = random;
    }

    @Override
    public String getPaddingName() {
        return "X9.23";
    }

    @Override
    public int addPadding(byte[] in, int inOff) {
        byte by = (byte)(in.length - inOff);
        while (inOff < in.length - 1) {
            in[inOff] = this.a == null ? (byte)0 : (byte)this.a.nextInt();
            ++inOff;
        }
        in[inOff] = by;
        return by;
    }

    @Override
    public int padCount(byte[] in) throws InvalidCipherTextException {
        int n2 = in[in.length - 1] & 0xFF;
        int n3 = in.length - n2;
        int n4 = (n3 | n2 - 1) >> 31;
        if (n4 != 0) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return n2;
    }
}

