/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.CharToByteConverter;
import com.enterprisedt.bouncycastle.crypto.PasswordConverter;
import com.enterprisedt.bouncycastle.util.Arrays;

public class Argon2Parameters {
    public static final int ARGON2_d = 0;
    public static final int ARGON2_i = 1;
    public static final int ARGON2_id = 2;
    public static final int ARGON2_VERSION_10 = 16;
    public static final int ARGON2_VERSION_13 = 19;
    private final byte[] a;
    private final byte[] b;
    private final byte[] c;
    private final int d;
    private final int e;
    private final int f;
    private final int g;
    private final int h;
    private final CharToByteConverter i;

    private Argon2Parameters(int type, byte[] salt, byte[] secret, byte[] additional, int iterations, int memory, int lanes, int version, CharToByteConverter converter) {
        this.a = Arrays.clone(salt);
        this.b = Arrays.clone(secret);
        this.c = Arrays.clone(additional);
        this.d = iterations;
        this.e = memory;
        this.f = lanes;
        this.g = version;
        this.h = type;
        this.i = converter;
    }

    public byte[] getSalt() {
        return Arrays.clone(this.a);
    }

    public byte[] getSecret() {
        return Arrays.clone(this.b);
    }

    public byte[] getAdditional() {
        return Arrays.clone(this.c);
    }

    public int getIterations() {
        return this.d;
    }

    public int getMemory() {
        return this.e;
    }

    public int getLanes() {
        return this.f;
    }

    public int getVersion() {
        return this.g;
    }

    public int getType() {
        return this.h;
    }

    public CharToByteConverter getCharToByteConverter() {
        return this.i;
    }

    public void clear() {
        Arrays.clear(this.a);
        Arrays.clear(this.b);
        Arrays.clear(this.c);
    }

    public static class Builder {
        private byte[] a;
        private byte[] b;
        private byte[] c;
        private int d;
        private int e;
        private int f;
        private int g;
        private final int h;
        private CharToByteConverter i = PasswordConverter.UTF8;

        public Builder() {
            this(1);
        }

        public Builder(int type) {
            this.h = type;
            this.f = 1;
            this.e = 4096;
            this.d = 3;
            this.g = 19;
        }

        public Builder withParallelism(int parallelism) {
            this.f = parallelism;
            return this;
        }

        public Builder withSalt(byte[] salt) {
            this.a = Arrays.clone(salt);
            return this;
        }

        public Builder withSecret(byte[] secret) {
            this.b = Arrays.clone(secret);
            return this;
        }

        public Builder withAdditional(byte[] additional) {
            this.c = Arrays.clone(additional);
            return this;
        }

        public Builder withIterations(int iterations) {
            this.d = iterations;
            return this;
        }

        public Builder withMemoryAsKB(int memory) {
            this.e = memory;
            return this;
        }

        public Builder withMemoryPowOfTwo(int memory) {
            this.e = 1 << memory;
            return this;
        }

        public Builder withVersion(int version) {
            this.g = version;
            return this;
        }

        public Builder withCharToByteConverter(CharToByteConverter converter) {
            this.i = converter;
            return this;
        }

        public Argon2Parameters build() {
            return new Argon2Parameters(this.h, this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.i);
        }

        public void clear() {
            Arrays.clear(this.a);
            Arrays.clear(this.b);
            Arrays.clear(this.c);
        }
    }
}

