/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.asn1.x9.X9ECParameters;
import com.enterprisedt.bouncycastle.math.ec.ECAlgorithms;
import com.enterprisedt.bouncycastle.math.ec.ECConstants;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class ECDomainParameters
implements ECConstants {
    private final ECCurve a;
    private final byte[] b;
    private final ECPoint c;
    private final BigInteger d;
    private final BigInteger e;
    private BigInteger f = null;

    public ECDomainParameters(X9ECParameters x9) {
        this(x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
    }

    public ECDomainParameters(ECCurve curve, ECPoint G, BigInteger n2) {
        this(curve, G, n2, ONE, null);
    }

    public ECDomainParameters(ECCurve curve, ECPoint G, BigInteger n2, BigInteger h2) {
        this(curve, G, n2, h2, null);
    }

    public ECDomainParameters(ECCurve curve, ECPoint G, BigInteger n2, BigInteger h2, byte[] seed) {
        if (curve == null) {
            throw new NullPointerException("curve");
        }
        if (n2 == null) {
            throw new NullPointerException("n");
        }
        this.a = curve;
        this.c = ECDomainParameters.a(curve, G);
        this.d = n2;
        this.e = h2;
        this.b = Arrays.clone(seed);
    }

    public ECCurve getCurve() {
        return this.a;
    }

    public ECPoint getG() {
        return this.c;
    }

    public BigInteger getN() {
        return this.d;
    }

    public BigInteger getH() {
        return this.e;
    }

    public synchronized BigInteger getHInv() {
        if (this.f == null) {
            this.f = BigIntegers.modOddInverseVar(this.d, this.e);
        }
        return this.f;
    }

    public byte[] getSeed() {
        return Arrays.clone(this.b);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ECDomainParameters)) {
            return false;
        }
        ECDomainParameters eCDomainParameters = (ECDomainParameters)obj;
        return this.a.equals(eCDomainParameters.a) && this.c.equals(eCDomainParameters.c) && this.d.equals(eCDomainParameters.d);
    }

    public int hashCode() {
        int n2 = 4;
        n2 *= 257;
        n2 ^= this.a.hashCode();
        n2 *= 257;
        n2 ^= this.c.hashCode();
        n2 *= 257;
        return n2 ^= this.d.hashCode();
    }

    public BigInteger validatePrivateScalar(BigInteger d2) {
        if (null == d2) {
            throw new NullPointerException("Scalar cannot be null");
        }
        if (d2.compareTo(ECConstants.ONE) < 0 || d2.compareTo(this.getN()) >= 0) {
            throw new IllegalArgumentException("Scalar is not in the interval [1, n - 1]");
        }
        return d2;
    }

    public ECPoint validatePublicPoint(ECPoint q2) {
        return ECDomainParameters.a(this.getCurve(), q2);
    }

    static ECPoint a(ECCurve eCCurve, ECPoint eCPoint) {
        if (null == eCPoint) {
            throw new NullPointerException("Point cannot be null");
        }
        if ((eCPoint = ECAlgorithms.importPoint(eCCurve, eCPoint).normalize()).isInfinity()) {
            throw new IllegalArgumentException("Point at infinity");
        }
        if (!eCPoint.isValid()) {
            throw new IllegalArgumentException("Point not on curve");
        }
        return eCPoint;
    }
}

