/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;

public final class Ed25519PrivateKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 32;
    public static final int SIGNATURE_SIZE = 64;
    private final byte[] b = new byte[32];
    private Ed25519PublicKeyParameters c;

    public Ed25519PrivateKeyParameters(SecureRandom random) {
        super(true);
        Ed25519.generatePrivateKey(random, this.b);
    }

    public Ed25519PrivateKeyParameters(byte[] buf) {
        this(Ed25519PrivateKeyParameters.a(buf), 0);
    }

    public Ed25519PrivateKeyParameters(byte[] buf, int off) {
        super(true);
        System.arraycopy(buf, off, this.b, 0, 32);
    }

    public Ed25519PrivateKeyParameters(InputStream input) throws IOException {
        super(true);
        if (32 != Streams.readFully(input, this.b)) {
            throw new EOFException("EOF encountered in middle of Ed25519 private key");
        }
    }

    public void encode(byte[] buf, int off) {
        System.arraycopy(this.b, 0, buf, off, 32);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ed25519PublicKeyParameters generatePublicKey() {
        byte[] byArray = this.b;
        synchronized (this.b) {
            if (null == this.c) {
                this.c = new Ed25519PublicKeyParameters(Ed25519.generatePublicKey(this.b, 0));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.c;
        }
    }

    public void sign(int algorithm, Ed25519PublicKeyParameters publicKey, byte[] ctx, byte[] msg, int msgOff, int msgLen, byte[] sig, int sigOff) {
        this.sign(algorithm, ctx, msg, msgOff, msgLen, sig, sigOff);
    }

    public void sign(int algorithm, byte[] ctx, byte[] msg, int msgOff, int msgLen, byte[] sig, int sigOff) {
        Ed25519PublicKeyParameters ed25519PublicKeyParameters = this.generatePublicKey();
        byte[] byArray = new byte[32];
        ed25519PublicKeyParameters.encode(byArray, 0);
        switch (algorithm) {
            case 0: {
                if (null != ctx) {
                    throw new IllegalArgumentException("ctx");
                }
                Ed25519.sign(this.b, 0, byArray, 0, msg, msgOff, msgLen, sig, sigOff);
                break;
            }
            case 1: {
                if (null == ctx) {
                    throw new NullPointerException("'ctx' cannot be null");
                }
                if (ctx.length > 255) {
                    throw new IllegalArgumentException("ctx");
                }
                Ed25519.sign(this.b, 0, byArray, 0, ctx, msg, msgOff, msgLen, sig, sigOff);
                break;
            }
            case 2: {
                if (null == ctx) {
                    throw new NullPointerException("'ctx' cannot be null");
                }
                if (ctx.length > 255) {
                    throw new IllegalArgumentException("ctx");
                }
                if (64 != msgLen) {
                    throw new IllegalArgumentException("msgLen");
                }
                Ed25519.signPrehash(this.b, 0, byArray, 0, ctx, msg, msgOff, sig, sigOff);
                break;
            }
            default: {
                throw new IllegalArgumentException("algorithm");
            }
        }
    }

    private static byte[] a(byte[] byArray) {
        if (byArray.length != 32) {
            throw new IllegalArgumentException("'buf' must have length 32");
        }
        return byArray;
    }
}

