/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class Ed25519PublicKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 32;
    private final Ed25519.PublicPoint b;

    public Ed25519PublicKeyParameters(byte[] buf) {
        this(Ed25519PublicKeyParameters.a(buf), 0);
    }

    public Ed25519PublicKeyParameters(byte[] buf, int off) {
        super(false);
        this.b = Ed25519PublicKeyParameters.a(buf, off);
    }

    public Ed25519PublicKeyParameters(InputStream input) throws IOException {
        super(false);
        byte[] byArray = new byte[32];
        if (32 != Streams.readFully(input, byArray)) {
            throw new EOFException("EOF encountered in middle of Ed25519 public key");
        }
        this.b = Ed25519PublicKeyParameters.a(byArray, 0);
    }

    public Ed25519PublicKeyParameters(Ed25519.PublicPoint publicPoint) {
        super(false);
        if (publicPoint == null) {
            throw new NullPointerException("'publicPoint' cannot be null");
        }
        this.b = publicPoint;
    }

    public void encode(byte[] buf, int off) {
        Ed25519.encodePublicPoint(this.b, buf, off);
    }

    public byte[] getEncoded() {
        byte[] byArray = new byte[32];
        this.encode(byArray, 0);
        return byArray;
    }

    public boolean verify(int algorithm, byte[] ctx, byte[] msg, int msgOff, int msgLen, byte[] sig, int sigOff) {
        switch (algorithm) {
            case 0: {
                if (null != ctx) {
                    throw new IllegalArgumentException("ctx");
                }
                return Ed25519.verify(sig, sigOff, this.b, msg, msgOff, msgLen);
            }
            case 1: {
                if (null == ctx) {
                    throw new NullPointerException("'ctx' cannot be null");
                }
                if (ctx.length > 255) {
                    throw new IllegalArgumentException("ctx");
                }
                return Ed25519.verify(sig, sigOff, this.b, ctx, msg, msgOff, msgLen);
            }
            case 2: {
                if (null == ctx) {
                    throw new NullPointerException("'ctx' cannot be null");
                }
                if (ctx.length > 255) {
                    throw new IllegalArgumentException("ctx");
                }
                if (64 != msgLen) {
                    throw new IllegalArgumentException("msgLen");
                }
                return Ed25519.verifyPrehash(sig, sigOff, this.b, ctx, msg, msgOff);
            }
        }
        throw new IllegalArgumentException("algorithm");
    }

    private static Ed25519.PublicPoint a(byte[] byArray, int n2) {
        Ed25519.PublicPoint publicPoint = Ed25519.validatePublicKeyPartialExport(byArray, n2);
        if (publicPoint == null) {
            throw new IllegalArgumentException("invalid public key");
        }
        return publicPoint;
    }

    private static byte[] a(byte[] byArray) {
        if (byArray.length != 32) {
            throw new IllegalArgumentException("'buf' must have length 32");
        }
        return byArray;
    }
}

