/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class Ed448PublicKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 57;
    private final Ed448.PublicPoint b;

    public Ed448PublicKeyParameters(byte[] buf) {
        this(Ed448PublicKeyParameters.a(buf), 0);
    }

    public Ed448PublicKeyParameters(byte[] buf, int off) {
        super(false);
        this.b = Ed448PublicKeyParameters.a(buf, off);
    }

    public Ed448PublicKeyParameters(InputStream input) throws IOException {
        super(false);
        byte[] byArray = new byte[57];
        if (57 != Streams.readFully(input, byArray)) {
            throw new EOFException("EOF encountered in middle of Ed448 public key");
        }
        this.b = Ed448PublicKeyParameters.a(byArray, 0);
    }

    public Ed448PublicKeyParameters(Ed448.PublicPoint publicPoint) {
        super(false);
        if (publicPoint == null) {
            throw new NullPointerException("'publicPoint' cannot be null");
        }
        this.b = publicPoint;
    }

    public void encode(byte[] buf, int off) {
        Ed448.encodePublicPoint(this.b, buf, off);
    }

    public byte[] getEncoded() {
        byte[] byArray = new byte[57];
        this.encode(byArray, 0);
        return byArray;
    }

    public boolean verify(int algorithm, byte[] ctx, byte[] msg, int msgOff, int msgLen, byte[] sig, int sigOff) {
        switch (algorithm) {
            case 0: {
                if (null == ctx) {
                    throw new NullPointerException("'ctx' cannot be null");
                }
                if (ctx.length > 255) {
                    throw new IllegalArgumentException("ctx");
                }
                return Ed448.verify(sig, sigOff, this.b, ctx, msg, msgOff, msgLen);
            }
            case 1: {
                if (null == ctx) {
                    throw new NullPointerException("'ctx' cannot be null");
                }
                if (ctx.length > 255) {
                    throw new IllegalArgumentException("ctx");
                }
                if (64 != msgLen) {
                    throw new IllegalArgumentException("msgLen");
                }
                return Ed448.verifyPrehash(sig, sigOff, this.b, ctx, msg, msgOff);
            }
        }
        throw new IllegalArgumentException("algorithm");
    }

    private static Ed448.PublicPoint a(byte[] byArray, int n2) {
        Ed448.PublicPoint publicPoint = Ed448.validatePublicKeyPartialExport(byArray, n2);
        if (publicPoint == null) {
            throw new IllegalArgumentException("invalid public key");
        }
        return publicPoint;
    }

    private static byte[] a(byte[] byArray) {
        if (byArray.length != 57) {
            throw new IllegalArgumentException("'buf' must have length 57");
        }
        return byArray;
    }
}

