/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.util.RadixConverter;
import com.enterprisedt.bouncycastle.util.Arrays;

public final class FPEParameters
implements CipherParameters {
    private final KeyParameter a;
    private final RadixConverter b;
    private final byte[] c;
    private final boolean d;

    public FPEParameters(KeyParameter key, int radix, byte[] tweak) {
        this(key, radix, tweak, false);
    }

    public FPEParameters(KeyParameter key, int radix, byte[] tweak, boolean useInverse) {
        this(key, new RadixConverter(radix), tweak, useInverse);
    }

    public FPEParameters(KeyParameter key, RadixConverter radixConverter, byte[] tweak, boolean useInverse) {
        this.a = key;
        this.b = radixConverter;
        this.c = Arrays.clone(tweak);
        this.d = useInverse;
    }

    public KeyParameter getKey() {
        return this.a;
    }

    public int getRadix() {
        return this.b.getRadix();
    }

    public RadixConverter getRadixConverter() {
        return this.b;
    }

    public byte[] getTweak() {
        return Arrays.clone(this.c);
    }

    public boolean isUsingInverseFunction() {
        return this.d;
    }
}

