/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.params.GOST3410ValidationParameters;
import java.math.BigInteger;

public class GOST3410Parameters
implements CipherParameters {
    private BigInteger a;
    private BigInteger b;
    private BigInteger c;
    private GOST3410ValidationParameters d;

    public GOST3410Parameters(BigInteger p2, BigInteger q2, BigInteger a2) {
        this.a = p2;
        this.b = q2;
        this.c = a2;
    }

    public GOST3410Parameters(BigInteger p2, BigInteger q2, BigInteger a2, GOST3410ValidationParameters params) {
        this.c = a2;
        this.a = p2;
        this.b = q2;
        this.d = params;
    }

    public BigInteger getP() {
        return this.a;
    }

    public BigInteger getQ() {
        return this.b;
    }

    public BigInteger getA() {
        return this.c;
    }

    public GOST3410ValidationParameters getValidationParameters() {
        return this.d;
    }

    public int hashCode() {
        return this.a.hashCode() ^ this.b.hashCode() ^ this.c.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GOST3410Parameters)) {
            return false;
        }
        GOST3410Parameters gOST3410Parameters = (GOST3410Parameters)obj;
        return gOST3410Parameters.getP().equals(this.a) && gOST3410Parameters.getQ().equals(this.b) && gOST3410Parameters.getA().equals(this.c);
    }
}

