/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.DerivationParameters;
import com.enterprisedt.bouncycastle.util.Arrays;

public final class KDFCounterParameters
implements DerivationParameters {
    private byte[] a;
    private byte[] b;
    private byte[] c;
    private int d;

    public KDFCounterParameters(byte[] ki, byte[] fixedInputDataCounterSuffix, int r2) {
        this(ki, null, fixedInputDataCounterSuffix, r2);
    }

    public KDFCounterParameters(byte[] ki, byte[] fixedInputDataCounterPrefix, byte[] fixedInputDataCounterSuffix, int r2) {
        if (ki == null) {
            throw new IllegalArgumentException("A KDF requires Ki (a seed) as input");
        }
        this.a = Arrays.clone(ki);
        this.b = fixedInputDataCounterPrefix == null ? new byte[0] : Arrays.clone(fixedInputDataCounterPrefix);
        this.c = fixedInputDataCounterSuffix == null ? new byte[0] : Arrays.clone(fixedInputDataCounterSuffix);
        if (r2 != 8 && r2 != 16 && r2 != 24 && r2 != 32) {
            throw new IllegalArgumentException("Length of counter should be 8, 16, 24 or 32");
        }
        this.d = r2;
    }

    public byte[] getKI() {
        return this.a;
    }

    public byte[] getFixedInputData() {
        return Arrays.clone(this.c);
    }

    public byte[] getFixedInputDataCounterPrefix() {
        return Arrays.clone(this.b);
    }

    public byte[] getFixedInputDataCounterSuffix() {
        return Arrays.clone(this.c);
    }

    public int getR() {
        return this.d;
    }
}

