/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.util.Arrays;

public class KeyParameter
implements CipherParameters {
    private byte[] a;

    public KeyParameter(byte[] key) {
        this(key, 0, key.length);
    }

    public KeyParameter(byte[] key, int keyOff, int keyLen) {
        this(keyLen);
        System.arraycopy(key, keyOff, this.a, 0, keyLen);
    }

    private KeyParameter(int length) {
        this.a = new byte[length];
    }

    public void copyTo(byte[] buf, int off, int len) {
        if (this.a.length != len) {
            throw new IllegalArgumentException("len");
        }
        System.arraycopy(this.a, 0, buf, off, len);
    }

    public byte[] getKey() {
        return this.a;
    }

    public int getKeyLength() {
        return this.a.length;
    }

    public KeyParameter reverse() {
        KeyParameter keyParameter = new KeyParameter(this.a.length);
        Arrays.reverse(this.a, keyParameter.a);
        return keyParameter;
    }
}

