/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.math.Primes;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import com.enterprisedt.bouncycastle.util.Properties;
import java.math.BigInteger;

public class RSAKeyParameters
extends AsymmetricKeyParameter {
    private static final BigIntegers.Cache b = new BigIntegers.Cache();
    private static final BigInteger c = new BigInteger("8138e8a0fcf3a4e84a771d40fd305d7f4aa59306d7251de54d98af8fe95729a1f73d893fa424cd2edc8636a6c3285e022b0e3866a565ae8108eed8591cd4fe8d2ce86165a978d719ebf647f362d33fca29cd179fb42401cbaf3df0c614056f9c8f3cfd51e474afb6bc6974f78db8aba8e9e517fded658591ab7502bd41849462f", 16);
    private static final BigInteger d = BigInteger.valueOf(1L);
    private BigInteger e;
    private BigInteger f;

    public RSAKeyParameters(boolean isPrivate, BigInteger modulus, BigInteger exponent) {
        this(isPrivate, modulus, exponent, false);
    }

    public RSAKeyParameters(boolean isPrivate, BigInteger modulus, BigInteger exponent, boolean isInternal) {
        super(isPrivate);
        if (!isPrivate && (exponent.intValue() & 1) == 0) {
            throw new IllegalArgumentException("RSA publicExponent is even");
        }
        this.e = b.contains(modulus) ? modulus : this.a(modulus, isInternal);
        this.f = exponent;
    }

    private BigInteger a(BigInteger bigInteger, boolean bl) {
        Primes.MROutput mROutput;
        int n2;
        if (bl) {
            b.add(bigInteger);
            return bigInteger;
        }
        if ((bigInteger.intValue() & 1) == 0) {
            throw new IllegalArgumentException("RSA modulus is even");
        }
        if (Properties.isOverrideSet("com.enterprisedt.bouncycastle.rsa.allow_unsafe_mod")) {
            return bigInteger;
        }
        int n3 = Properties.asInteger("com.enterprisedt.bouncycastle.rsa.max_size", 15360);
        if (n3 < (n2 = bigInteger.bitLength())) {
            throw new IllegalArgumentException("modulus value out of range");
        }
        if (!bigInteger.gcd(c).equals(d)) {
            throw new IllegalArgumentException("RSA modulus has a small prime factor");
        }
        int n4 = bigInteger.bitLength() / 2;
        int n5 = Properties.asInteger("com.enterprisedt.bouncycastle.rsa.max_mr_tests", RSAKeyParameters.a(n4));
        if (n5 > 0 && !(mROutput = Primes.enhancedMRProbablePrimeTest(bigInteger, CryptoServicesRegistrar.getSecureRandom(), n5)).isProvablyComposite()) {
            throw new IllegalArgumentException("RSA modulus is not composite");
        }
        b.add(bigInteger);
        return bigInteger;
    }

    private static int a(int n2) {
        int n3 = n2 >= 1536 ? 3 : (n2 >= 1024 ? 4 : (n2 >= 512 ? 7 : 50));
        return n3;
    }

    public BigInteger getModulus() {
        return this.e;
    }

    public BigInteger getExponent() {
        return this.f;
    }
}

