/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.X448PublicKeyParameters;
import com.enterprisedt.bouncycastle.math.ec.rfc7748.X448;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;

public final class X448PrivateKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 56;
    public static final int SECRET_SIZE = 56;
    private final byte[] b = new byte[56];

    public X448PrivateKeyParameters(SecureRandom random) {
        super(true);
        X448.generatePrivateKey(random, this.b);
    }

    public X448PrivateKeyParameters(byte[] buf) {
        this(X448PrivateKeyParameters.a(buf), 0);
    }

    public X448PrivateKeyParameters(byte[] buf, int off) {
        super(true);
        System.arraycopy(buf, off, this.b, 0, 56);
    }

    public X448PrivateKeyParameters(InputStream input) throws IOException {
        super(true);
        if (56 != Streams.readFully(input, this.b)) {
            throw new EOFException("EOF encountered in middle of X448 private key");
        }
    }

    public void encode(byte[] buf, int off) {
        System.arraycopy(this.b, 0, buf, off, 56);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.b);
    }

    public X448PublicKeyParameters generatePublicKey() {
        byte[] byArray = new byte[56];
        X448.generatePublicKey(this.b, 0, byArray, 0);
        return new X448PublicKeyParameters(byArray, 0);
    }

    public void generateSecret(X448PublicKeyParameters publicKey, byte[] buf, int off) {
        byte[] byArray = new byte[56];
        publicKey.encode(byArray, 0);
        if (!X448.calculateAgreement(this.b, 0, byArray, 0, buf, off)) {
            throw new IllegalStateException("X448 agreement failed");
        }
    }

    private static byte[] a(byte[] byArray) {
        if (byArray.length != 56) {
            throw new IllegalArgumentException("'buf' must have length 56");
        }
        return byArray;
    }
}

