/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.X25519PublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.X448PublicKeyParameters;

public class XDHUPublicParameters
implements CipherParameters {
    private AsymmetricKeyParameter a;
    private AsymmetricKeyParameter b;

    public XDHUPublicParameters(AsymmetricKeyParameter staticPublicKey, AsymmetricKeyParameter ephemeralPublicKey) {
        if (staticPublicKey == null) {
            throw new NullPointerException("staticPublicKey cannot be null");
        }
        if (!(staticPublicKey instanceof X448PublicKeyParameters) && !(staticPublicKey instanceof X25519PublicKeyParameters)) {
            throw new IllegalArgumentException("only X25519 and X448 paramaters can be used");
        }
        if (ephemeralPublicKey == null) {
            throw new NullPointerException("ephemeralPublicKey cannot be null");
        }
        if (!staticPublicKey.getClass().isAssignableFrom(ephemeralPublicKey.getClass())) {
            throw new IllegalArgumentException("static and ephemeral public keys have different domain parameters");
        }
        this.a = staticPublicKey;
        this.b = ephemeralPublicKey;
    }

    public AsymmetricKeyParameter getStaticPublicKey() {
        return this.a;
    }

    public AsymmetricKeyParameter getEphemeralPublicKey() {
        return this.b;
    }
}

