/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.parsers;

import com.enterprisedt.bouncycastle.crypto.KeyParser;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.IOException;
import java.io.InputStream;

public class ECIESPublicKeyParser
implements KeyParser {
    private ECDomainParameters a;

    public ECIESPublicKeyParser(ECDomainParameters ecParams) {
        this.a = ecParams;
    }

    @Override
    public AsymmetricKeyParameter readKey(InputStream stream) throws IOException {
        byte[] byArray;
        int n2 = stream.read();
        switch (n2) {
            case 0: {
                throw new IOException("Sender's public key invalid.");
            }
            case 2: 
            case 3: {
                byArray = new byte[1 + (this.a.getCurve().getFieldSize() + 7) / 8];
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                byArray = new byte[1 + 2 * ((this.a.getCurve().getFieldSize() + 7) / 8)];
                break;
            }
            default: {
                throw new IOException("Sender's public key has invalid point encoding 0x" + Integer.toString(n2, 16));
            }
        }
        byArray[0] = (byte)n2;
        Streams.readFully(stream, byArray, 1, byArray.length - 1);
        return new ECPublicKeyParameters(this.a.getCurve().decodePoint(byArray), this.a);
    }
}

