/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.parsers;

import com.enterprisedt.bouncycastle.crypto.KeyParser;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.X25519PublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.X448PublicKeyParameters;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.IOException;
import java.io.InputStream;

public class XIESPublicKeyParser
implements KeyParser {
    private final boolean a;

    public XIESPublicKeyParser(boolean isX25519) {
        this.a = isX25519;
    }

    @Override
    public AsymmetricKeyParameter readKey(InputStream stream) throws IOException {
        int n2 = this.a ? 32 : 56;
        byte[] byArray = new byte[n2];
        Streams.readFully(stream, byArray, 0, byArray.length);
        return this.a ? new X25519PublicKeyParameters(byArray, 0) : new X448PublicKeyParameters(byArray, 0);
    }
}

