/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.prng;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.prng.EntropySource;

public class X931RNG {
    private final BlockCipher a;
    private final EntropySource b;
    private final byte[] c;
    private final byte[] d;
    private final byte[] e;
    private byte[] f;
    private long g = 1L;

    public X931RNG(BlockCipher engine, byte[] dateTimeVector, EntropySource entropySource) {
        this.a = engine;
        this.b = entropySource;
        this.c = new byte[engine.getBlockSize()];
        System.arraycopy(dateTimeVector, 0, this.c, 0, this.c.length);
        this.d = new byte[engine.getBlockSize()];
        this.e = new byte[engine.getBlockSize()];
    }

    int a(byte[] byArray, boolean bl) {
        int n2;
        if (this.e.length == 8) {
            if (this.g > 32768L) {
                return -1;
            }
            if (X931RNG.a(byArray, 512)) {
                throw new IllegalArgumentException("Number of bits per request limited to 4096");
            }
        } else {
            if (this.g > 0x800000L) {
                return -1;
            }
            if (X931RNG.a(byArray, 32768)) {
                throw new IllegalArgumentException("Number of bits per request limited to 262144");
            }
        }
        if (bl || this.f == null) {
            this.f = this.b.getEntropy();
            if (this.f.length != this.a.getBlockSize()) {
                throw new IllegalStateException("Insufficient entropy returned");
            }
        }
        int n3 = byArray.length / this.e.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.a.processBlock(this.c, 0, this.d, 0);
            this.a(this.e, this.d, this.f);
            this.a(this.f, this.e, this.d);
            System.arraycopy(this.e, 0, byArray, n2 * this.e.length, this.e.length);
            this.a(this.c);
        }
        n2 = byArray.length - n3 * this.e.length;
        if (n2 > 0) {
            this.a.processBlock(this.c, 0, this.d, 0);
            this.a(this.e, this.d, this.f);
            this.a(this.f, this.e, this.d);
            System.arraycopy(this.e, 0, byArray, n3 * this.e.length, n2);
            this.a(this.c);
        }
        ++this.g;
        return byArray.length * 8;
    }

    void a() {
        this.f = this.b.getEntropy();
        if (this.f.length != this.a.getBlockSize()) {
            throw new IllegalStateException("Insufficient entropy returned");
        }
        this.g = 1L;
    }

    EntropySource b() {
        return this.b;
    }

    private void a(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            byArray[i2] = (byte)(byArray2[i2] ^ byArray3[i2]);
        }
        this.a.processBlock(byArray, 0, byArray, 0);
    }

    private void a(byte[] byArray) {
        int n2 = byArray.length - 1;
        while (n2 >= 0) {
            int n3 = n2--;
            byArray[n3] = (byte)(byArray[n3] + 1);
            if (byArray[n3] != 0) break;
        }
    }

    private static boolean a(byte[] byArray, int n2) {
        return byArray != null && byArray.length > n2;
    }
}

