/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.prng.drbg;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.prng.EntropySource;
import com.enterprisedt.bouncycastle.crypto.prng.drbg.SP80090DRBG;
import com.enterprisedt.bouncycastle.crypto.prng.drbg.a;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Bytes;
import com.enterprisedt.bouncycastle.util.encoders.Hex;

public class CTRSP800DRBG
implements SP80090DRBG {
    private EntropySource a;
    private BlockCipher b;
    private int c;
    private int d;
    private int e;
    private byte[] f;
    private byte[] g;
    private long h = 0L;
    private boolean i = false;
    private static final byte[] j = Hex.decodeStrict("000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F");

    public CTRSP800DRBG(BlockCipher engine, int keySizeInBits, int securityStrength, EntropySource entropySource, byte[] personalizationString, byte[] nonce) {
        this.a = entropySource;
        this.b = engine;
        this.c = keySizeInBits;
        this.e = securityStrength;
        this.d = keySizeInBits + engine.getBlockSize() * 8;
        this.i = this.a(engine);
        if (securityStrength > 256) {
            throw new IllegalArgumentException("Requested security strength is not supported by the derivation function");
        }
        if (this.a(engine, keySizeInBits) < securityStrength) {
            throw new IllegalArgumentException("Requested security strength is not supported by block cipher and key size");
        }
        if (entropySource.entropySize() < securityStrength) {
            throw new IllegalArgumentException("Not enough entropy for security strength required");
        }
        byte[] byArray = this.a();
        this.a(byArray, nonce, personalizationString);
    }

    private void a(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = Arrays.concatenate(byArray, byArray2, byArray3);
        byte[] byArray5 = this.a(byArray4, this.d);
        int n2 = this.b.getBlockSize();
        this.f = new byte[(this.c + 7) / 8];
        this.g = new byte[n2];
        this.b(byArray5, this.f, this.g);
        this.h = 1L;
    }

    private void b(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[byArray.length];
        byte[] byArray5 = new byte[this.b.getBlockSize()];
        int n2 = 0;
        int n3 = this.b.getBlockSize();
        this.b.init(true, new KeyParameter(this.a(byArray2)));
        while (n2 * n3 < byArray.length) {
            this.c(byArray3);
            this.b.processBlock(byArray3, 0, byArray5, 0);
            int n4 = byArray4.length - n2 * n3 > n3 ? n3 : byArray4.length - n2 * n3;
            System.arraycopy(byArray5, 0, byArray4, n2 * n3, n4);
            ++n2;
        }
        Bytes.xorTo(byArray.length, byArray, byArray4);
        System.arraycopy(byArray4, 0, byArray2, 0, byArray2.length);
        System.arraycopy(byArray4, byArray2.length, byArray3, 0, byArray3.length);
    }

    private void b(byte[] byArray) {
        byte[] byArray2 = Arrays.concatenate(this.a(), byArray);
        byArray2 = this.a(byArray2, this.d);
        this.b(byArray2, this.f, this.g);
        this.h = 1L;
    }

    private void c(byte[] byArray) {
        int n2 = 1;
        for (int i2 = 1; i2 <= byArray.length; ++i2) {
            int n3 = (byArray[byArray.length - i2] & 0xFF) + n2;
            n2 = n3 > 255 ? 1 : 0;
            byArray[byArray.length - i2] = (byte)n3;
        }
    }

    private byte[] a() {
        byte[] byArray = this.a.getEntropy();
        if (byArray.length < (this.e + 7) / 8) {
            throw new IllegalStateException("Insufficient entropy provided by entropy source");
        }
        return byArray;
    }

    private byte[] a(byte[] byArray, int n2) {
        int n3 = this.b.getBlockSize();
        int n4 = byArray.length;
        int n5 = n2 / 8;
        int n6 = 8 + n4 + 1;
        int n7 = (n6 + n3 - 1) / n3 * n3;
        byte[] byArray2 = new byte[n7];
        this.a(byArray2, n4, 0);
        this.a(byArray2, n5, 4);
        System.arraycopy(byArray, 0, byArray2, 8, n4);
        byArray2[8 + n4] = -128;
        byte[] byArray3 = new byte[this.c / 8 + n3];
        byte[] byArray4 = new byte[n3];
        byte[] byArray5 = new byte[n3];
        int n8 = 0;
        byte[] byArray6 = new byte[this.c / 8];
        System.arraycopy(j, 0, byArray6, 0, byArray6.length);
        while (n8 * n3 * 8 < this.c + n3 * 8) {
            this.a(byArray5, n8, 0);
            this.a(byArray4, byArray6, byArray5, byArray2);
            int n9 = byArray3.length - n8 * n3 > n3 ? n3 : byArray3.length - n8 * n3;
            System.arraycopy(byArray4, 0, byArray3, n8 * n3, n9);
            ++n8;
        }
        byte[] byArray7 = new byte[n3];
        System.arraycopy(byArray3, 0, byArray6, 0, byArray6.length);
        System.arraycopy(byArray3, byArray6.length, byArray7, 0, byArray7.length);
        byArray3 = new byte[n2 / 8];
        n8 = 0;
        this.b.init(true, new KeyParameter(this.a(byArray6)));
        while (n8 * n3 < byArray3.length) {
            this.b.processBlock(byArray7, 0, byArray7, 0);
            int n10 = byArray3.length - n8 * n3 > n3 ? n3 : byArray3.length - n8 * n3;
            System.arraycopy(byArray7, 0, byArray3, n8 * n3, n10);
            ++n8;
        }
        return byArray3;
    }

    private void a(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        int n2 = this.b.getBlockSize();
        byte[] byArray5 = new byte[n2];
        int n3 = byArray4.length / n2;
        byte[] byArray6 = new byte[n2];
        this.b.init(true, new KeyParameter(this.a(byArray2)));
        this.b.processBlock(byArray3, 0, byArray5, 0);
        for (int i2 = 0; i2 < n3; ++i2) {
            Bytes.xor(n2, byArray5, 0, byArray4, i2 * n2, byArray6, 0);
            this.b.processBlock(byArray6, 0, byArray5, 0);
        }
        System.arraycopy(byArray5, 0, byArray, 0, byArray.length);
    }

    private void a(byte[] byArray, int n2, int n3) {
        byArray[n3 + 0] = (byte)(n2 >> 24);
        byArray[n3 + 1] = (byte)(n2 >> 16);
        byArray[n3 + 2] = (byte)(n2 >> 8);
        byArray[n3 + 3] = (byte)n2;
    }

    @Override
    public int getBlockSize() {
        return this.g.length * 8;
    }

    @Override
    public int generate(byte[] output, byte[] additionalInput, boolean predictionResistant) {
        if (this.i) {
            if (this.h > 0x80000000L) {
                return -1;
            }
            if (com.enterprisedt.bouncycastle.crypto.prng.drbg.a.a(output, 512)) {
                throw new IllegalArgumentException("Number of bits per request limited to 4096");
            }
        } else {
            if (this.h > 0x800000000000L) {
                return -1;
            }
            if (com.enterprisedt.bouncycastle.crypto.prng.drbg.a.a(output, 32768)) {
                throw new IllegalArgumentException("Number of bits per request limited to 262144");
            }
        }
        if (predictionResistant) {
            this.b(additionalInput);
            additionalInput = null;
        }
        if (additionalInput != null) {
            additionalInput = this.a(additionalInput, this.d);
            this.b(additionalInput, this.f, this.g);
        } else {
            additionalInput = new byte[this.d / 8];
        }
        byte[] byArray = new byte[this.g.length];
        this.b.init(true, new KeyParameter(this.a(this.f)));
        for (int i2 = 0; i2 <= output.length / byArray.length; ++i2) {
            int n2;
            int n3 = n2 = output.length - i2 * byArray.length > byArray.length ? byArray.length : output.length - i2 * this.g.length;
            if (n2 == 0) continue;
            this.c(this.g);
            this.b.processBlock(this.g, 0, byArray, 0);
            System.arraycopy(byArray, 0, output, i2 * byArray.length, n2);
        }
        this.b(additionalInput, this.f, this.g);
        ++this.h;
        return output.length * 8;
    }

    @Override
    public void reseed(byte[] additionalInput) {
        this.b(additionalInput);
    }

    private boolean a(BlockCipher blockCipher) {
        return blockCipher.getAlgorithmName().equals("DESede") || blockCipher.getAlgorithmName().equals("TDEA");
    }

    private int a(BlockCipher blockCipher, int n2) {
        if (this.a(blockCipher) && n2 == 168) {
            return 112;
        }
        if (blockCipher.getAlgorithmName().equals("AES")) {
            return n2;
        }
        return -1;
    }

    byte[] a(byte[] byArray) {
        if (this.i) {
            byte[] byArray2 = new byte[24];
            this.a(byArray, 0, byArray2, 0);
            this.a(byArray, 7, byArray2, 8);
            this.a(byArray, 14, byArray2, 16);
            return byArray2;
        }
        return byArray;
    }

    private void a(byte[] byArray, int n2, byte[] byArray2, int n3) {
        byArray2[n3 + 0] = (byte)(byArray[n2 + 0] & 0xFE);
        byArray2[n3 + 1] = (byte)(byArray[n2 + 0] << 7 | (byArray[n2 + 1] & 0xFC) >>> 1);
        byArray2[n3 + 2] = (byte)(byArray[n2 + 1] << 6 | (byArray[n2 + 2] & 0xF8) >>> 2);
        byArray2[n3 + 3] = (byte)(byArray[n2 + 2] << 5 | (byArray[n2 + 3] & 0xF0) >>> 3);
        byArray2[n3 + 4] = (byte)(byArray[n2 + 3] << 4 | (byArray[n2 + 4] & 0xE0) >>> 4);
        byArray2[n3 + 5] = (byte)(byArray[n2 + 4] << 3 | (byArray[n2 + 5] & 0xC0) >>> 5);
        byArray2[n3 + 6] = (byte)(byArray[n2 + 5] << 2 | (byArray[n2 + 6] & 0x80) >>> 6);
        byArray2[n3 + 7] = (byte)(byArray[n2 + 6] << 1);
        for (int i2 = n3; i2 <= n3 + 7; ++i2) {
            byte by = byArray2[i2];
            byArray2[i2] = (byte)(by & 0xFE | (by >> 1 ^ by >> 2 ^ by >> 3 ^ by >> 4 ^ by >> 5 ^ by >> 6 ^ by >> 7 ^ 1) & 1);
        }
    }
}

