/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.signers;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DSA;
import com.enterprisedt.bouncycastle.crypto.DSAExt;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.Signer;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.signers.DSAEncoding;
import com.enterprisedt.bouncycastle.crypto.signers.StandardDSAEncoding;
import java.math.BigInteger;

public class DSADigestSigner
implements Signer {
    private final DSA a;
    private final Digest b;
    private final DSAEncoding c;
    private boolean d;

    public DSADigestSigner(DSA dsa, Digest digest) {
        this.a = dsa;
        this.b = digest;
        this.c = StandardDSAEncoding.INSTANCE;
    }

    public DSADigestSigner(DSAExt dsa, Digest digest, DSAEncoding encoding) {
        this.a = dsa;
        this.b = digest;
        this.c = encoding;
    }

    @Override
    public void init(boolean forSigning, CipherParameters parameters) {
        this.d = forSigning;
        AsymmetricKeyParameter asymmetricKeyParameter = parameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)parameters).getParameters() : (AsymmetricKeyParameter)parameters;
        if (forSigning && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Signing Requires Private Key.");
        }
        if (!forSigning && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Verification Requires Public Key.");
        }
        this.reset();
        this.a.init(forSigning, parameters);
    }

    @Override
    public void update(byte input) {
        this.b.update(input);
    }

    @Override
    public void update(byte[] input, int inOff, int length) {
        this.b.update(input, inOff, length);
    }

    @Override
    public byte[] generateSignature() {
        if (!this.d) {
            throw new IllegalStateException("DSADigestSigner not initialised for signature generation.");
        }
        byte[] byArray = new byte[this.b.getDigestSize()];
        this.b.doFinal(byArray, 0);
        BigInteger[] bigIntegerArray = this.a.generateSignature(byArray);
        try {
            return this.c.encode(this.getOrder(), bigIntegerArray[0], bigIntegerArray[1]);
        }
        catch (Exception exception) {
            throw new IllegalStateException("unable to encode signature");
        }
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        if (this.d) {
            throw new IllegalStateException("DSADigestSigner not initialised for verification");
        }
        byte[] byArray = new byte[this.b.getDigestSize()];
        this.b.doFinal(byArray, 0);
        try {
            BigInteger[] bigIntegerArray = this.c.decode(this.getOrder(), signature);
            return this.a.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void reset() {
        this.b.reset();
    }

    protected BigInteger getOrder() {
        return this.a instanceof DSAExt ? ((DSAExt)this.a).getOrder() : null;
    }
}

