/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.signers;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DSAExt;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.signers.a;
import com.enterprisedt.bouncycastle.math.ec.ECAlgorithms;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.ECMultiplier;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSTU4145Signer
implements DSAExt {
    private static final BigInteger a = BigInteger.valueOf(1L);
    private ECKeyParameters b;
    private SecureRandom c;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
                this.c = parametersWithRandom.getRandom();
                param = parametersWithRandom.getParameters();
            } else {
                this.c = CryptoServicesRegistrar.getSecureRandom();
            }
            this.b = (ECPrivateKeyParameters)param;
        } else {
            this.b = (ECPublicKeyParameters)param;
        }
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.signers.a.a("DSTU4145", this.b, forSigning));
    }

    @Override
    public BigInteger getOrder() {
        return this.b.getParameters().getN();
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        BigInteger bigInteger;
        ECFieldElement eCFieldElement;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        ECFieldElement eCFieldElement2;
        ECDomainParameters eCDomainParameters = this.b.getParameters();
        ECCurve eCCurve = eCDomainParameters.getCurve();
        ECFieldElement eCFieldElement3 = DSTU4145Signer.a(eCCurve, message);
        if (eCFieldElement3.isZero()) {
            eCFieldElement3 = eCCurve.fromBigInteger(a);
        }
        BigInteger bigInteger4 = eCDomainParameters.getN();
        BigInteger bigInteger5 = ((ECPrivateKeyParameters)this.b).getD();
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        do {
            bigInteger3 = DSTU4145Signer.a(bigInteger4, this.c);
        } while ((eCFieldElement2 = eCMultiplier.multiply(eCDomainParameters.getG(), bigInteger3).normalize().getAffineXCoord()).isZero() || (bigInteger2 = DSTU4145Signer.a(bigInteger4, eCFieldElement = eCFieldElement3.multiply(eCFieldElement2))).signum() == 0 || (bigInteger = bigInteger2.multiply(bigInteger5).add(bigInteger3).mod(bigInteger4)).signum() == 0);
        return new BigInteger[]{bigInteger2, bigInteger};
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r2, BigInteger s2) {
        ECPoint eCPoint;
        if (r2.signum() <= 0 || s2.signum() <= 0) {
            return false;
        }
        ECDomainParameters eCDomainParameters = this.b.getParameters();
        BigInteger bigInteger = eCDomainParameters.getN();
        if (r2.compareTo(bigInteger) >= 0 || s2.compareTo(bigInteger) >= 0) {
            return false;
        }
        ECCurve eCCurve = eCDomainParameters.getCurve();
        ECFieldElement eCFieldElement = DSTU4145Signer.a(eCCurve, message);
        if (eCFieldElement.isZero()) {
            eCFieldElement = eCCurve.fromBigInteger(a);
        }
        if ((eCPoint = ECAlgorithms.sumOfTwoMultiplies(eCDomainParameters.getG(), s2, ((ECPublicKeyParameters)this.b).getQ(), r2).normalize()).isInfinity()) {
            return false;
        }
        ECFieldElement eCFieldElement2 = eCFieldElement.multiply(eCPoint.getAffineXCoord());
        return DSTU4145Signer.a(bigInteger, eCFieldElement2).compareTo(r2) == 0;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    private static BigInteger a(BigInteger bigInteger, SecureRandom secureRandom) {
        return BigIntegers.createRandomBigInteger(bigInteger.bitLength() - 1, secureRandom);
    }

    private static ECFieldElement a(ECCurve eCCurve, byte[] byArray) {
        byte[] byArray2 = Arrays.reverse(byArray);
        return eCCurve.fromBigInteger(DSTU4145Signer.a(new BigInteger(1, byArray2), eCCurve.getFieldSize()));
    }

    private static BigInteger a(BigInteger bigInteger, ECFieldElement eCFieldElement) {
        return DSTU4145Signer.a(eCFieldElement.toBigInteger(), bigInteger.bitLength() - 1);
    }

    private static BigInteger a(BigInteger bigInteger, int n2) {
        if (bigInteger.bitLength() > n2) {
            bigInteger = bigInteger.mod(a.shiftLeft(n2));
        }
        return bigInteger;
    }
}

