/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.signers;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.Signer;
import com.enterprisedt.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.signers.a;
import com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519;
import com.enterprisedt.bouncycastle.util.Arrays;

public class Ed25519phSigner
implements Signer {
    private final Digest a = Ed25519.createPrehash();
    private final byte[] b;
    private boolean c;
    private Ed25519PrivateKeyParameters d;
    private Ed25519PublicKeyParameters e;

    public Ed25519phSigner(byte[] context) {
        if (null == context) {
            throw new NullPointerException("'context' cannot be null");
        }
        this.b = Arrays.clone(context);
    }

    @Override
    public void init(boolean forSigning, CipherParameters parameters) {
        this.c = forSigning;
        if (forSigning) {
            this.d = (Ed25519PrivateKeyParameters)parameters;
            this.e = null;
        } else {
            this.d = null;
            this.e = (Ed25519PublicKeyParameters)parameters;
        }
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.signers.a.a("Ed25519", 128, parameters, forSigning));
        this.reset();
    }

    @Override
    public void update(byte b2) {
        this.a.update(b2);
    }

    @Override
    public void update(byte[] buf, int off, int len) {
        this.a.update(buf, off, len);
    }

    @Override
    public byte[] generateSignature() {
        if (!this.c || null == this.d) {
            throw new IllegalStateException("Ed25519phSigner not initialised for signature generation.");
        }
        byte[] byArray = new byte[64];
        if (64 != this.a.doFinal(byArray, 0)) {
            throw new IllegalStateException("Prehash digest failed");
        }
        byte[] byArray2 = new byte[64];
        this.d.sign(2, this.b, byArray, 0, 64, byArray2, 0);
        return byArray2;
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        if (this.c || null == this.e) {
            throw new IllegalStateException("Ed25519phSigner not initialised for verification");
        }
        if (64 != signature.length) {
            this.a.reset();
            return false;
        }
        byte[] byArray = new byte[64];
        if (64 != this.a.doFinal(byArray, 0)) {
            throw new IllegalStateException("Prehash digest failed");
        }
        return this.e.verify(2, this.b, byArray, 0, 64, signature, 0);
    }

    @Override
    public void reset() {
        this.a.reset();
    }
}

