/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.signers;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.Signer;
import com.enterprisedt.bouncycastle.crypto.Xof;
import com.enterprisedt.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.signers.a;
import com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed448;
import com.enterprisedt.bouncycastle.util.Arrays;

public class Ed448phSigner
implements Signer {
    private final Xof a = Ed448.createPrehash();
    private final byte[] b;
    private boolean c;
    private Ed448PrivateKeyParameters d;
    private Ed448PublicKeyParameters e;

    public Ed448phSigner(byte[] context) {
        if (null == context) {
            throw new NullPointerException("'context' cannot be null");
        }
        this.b = Arrays.clone(context);
    }

    @Override
    public void init(boolean forSigning, CipherParameters parameters) {
        this.c = forSigning;
        if (forSigning) {
            this.d = (Ed448PrivateKeyParameters)parameters;
            this.e = null;
        } else {
            this.d = null;
            this.e = (Ed448PublicKeyParameters)parameters;
        }
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.signers.a.a("Ed448", 224, parameters, forSigning));
        this.reset();
    }

    @Override
    public void update(byte b2) {
        this.a.update(b2);
    }

    @Override
    public void update(byte[] buf, int off, int len) {
        this.a.update(buf, off, len);
    }

    @Override
    public byte[] generateSignature() {
        if (!this.c || null == this.d) {
            throw new IllegalStateException("Ed448phSigner not initialised for signature generation.");
        }
        byte[] byArray = new byte[64];
        if (64 != this.a.doFinal(byArray, 0, 64)) {
            throw new IllegalStateException("Prehash digest failed");
        }
        byte[] byArray2 = new byte[114];
        this.d.sign(1, this.b, byArray, 0, 64, byArray2, 0);
        return byArray2;
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        if (this.c || null == this.e) {
            throw new IllegalStateException("Ed448phSigner not initialised for verification");
        }
        if (114 != signature.length) {
            this.a.reset();
            return false;
        }
        byte[] byArray = new byte[64];
        if (64 != this.a.doFinal(byArray, 0, 64)) {
            throw new IllegalStateException("Prehash digest failed");
        }
        return this.e.verify(1, this.b, byArray, 0, 64, signature, 0);
    }

    @Override
    public void reset() {
        this.a.reset();
    }
}

