/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.signers;

import com.enterprisedt.bouncycastle.crypto.signers.DSAEncoding;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class PlainDSAEncoding
implements DSAEncoding {
    public static final PlainDSAEncoding INSTANCE = new PlainDSAEncoding();

    @Override
    public byte[] encode(BigInteger n2, BigInteger r2, BigInteger s2) {
        int n3 = BigIntegers.getUnsignedByteLength(n2);
        byte[] byArray = new byte[n3 * 2];
        this.a(n2, r2, byArray, 0, n3);
        this.a(n2, s2, byArray, n3, n3);
        return byArray;
    }

    @Override
    public BigInteger[] decode(BigInteger n2, byte[] encoding) {
        int n3 = BigIntegers.getUnsignedByteLength(n2);
        if (encoding.length != n3 * 2) {
            throw new IllegalArgumentException("Encoding has incorrect length");
        }
        return new BigInteger[]{this.decodeValue(n2, encoding, 0, n3), this.decodeValue(n2, encoding, n3, n3)};
    }

    protected BigInteger checkValue(BigInteger n2, BigInteger x) {
        if (x.signum() < 0 || x.compareTo(n2) >= 0) {
            throw new IllegalArgumentException("Value out of range");
        }
        return x;
    }

    protected BigInteger decodeValue(BigInteger n2, byte[] buf, int off, int len) {
        byte[] byArray = Arrays.copyOfRange(buf, off, off + len);
        return this.checkValue(n2, new BigInteger(1, byArray));
    }

    private void a(BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n2, int n3) {
        byte[] byArray2 = this.checkValue(bigInteger, bigInteger2).toByteArray();
        int n4 = Math.max(0, byArray2.length - n3);
        int n5 = byArray2.length - n4;
        int n6 = n3 - n5;
        Arrays.fill(byArray, n2, n2 + n6, (byte)0);
        System.arraycopy(byArray2, n4, byArray, n2 + n6, n5);
    }
}

