/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.signers;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoException;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.Signer;
import com.enterprisedt.bouncycastle.crypto.digests.SM3Digest;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithID;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.signers.DSAEncoding;
import com.enterprisedt.bouncycastle.crypto.signers.DSAKCalculator;
import com.enterprisedt.bouncycastle.crypto.signers.RandomDSAKCalculator;
import com.enterprisedt.bouncycastle.crypto.signers.StandardDSAEncoding;
import com.enterprisedt.bouncycastle.crypto.signers.a;
import com.enterprisedt.bouncycastle.math.ec.ECAlgorithms;
import com.enterprisedt.bouncycastle.math.ec.ECConstants;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.ECMultiplier;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SM2Signer
implements Signer,
ECConstants {
    private final DSAKCalculator a = new RandomDSAKCalculator();
    private final Digest b;
    private final DSAEncoding c;
    private ECDomainParameters d;
    private ECPoint e;
    private ECKeyParameters f;
    private byte[] g;

    public SM2Signer() {
        this(StandardDSAEncoding.INSTANCE, new SM3Digest());
    }

    public SM2Signer(Digest digest) {
        this(StandardDSAEncoding.INSTANCE, digest);
    }

    public SM2Signer(DSAEncoding encoding) {
        this.c = encoding;
        this.b = new SM3Digest();
    }

    public SM2Signer(DSAEncoding encoding, Digest digest) {
        this.c = encoding;
        this.b = digest;
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        byte[] byArray;
        CipherParameters cipherParameters;
        if (param instanceof ParametersWithID) {
            cipherParameters = ((ParametersWithID)param).getParameters();
            byArray = ((ParametersWithID)param).getID();
            if (byArray.length >= 8192) {
                throw new IllegalArgumentException("SM2 user ID must be less than 2^13 bits long");
            }
        } else {
            cipherParameters = param;
            byArray = Hex.decodeStrict("31323334353637383132333435363738");
        }
        if (forSigning) {
            Object object;
            if (cipherParameters instanceof ParametersWithRandom) {
                object = (ParametersWithRandom)cipherParameters;
                this.f = (ECKeyParameters)((ParametersWithRandom)object).getParameters();
                this.d = this.f.getParameters();
                this.a.init(this.d.getN(), ((ParametersWithRandom)object).getRandom());
            } else {
                this.f = (ECKeyParameters)cipherParameters;
                this.d = this.f.getParameters();
                this.a.init(this.d.getN(), CryptoServicesRegistrar.getSecureRandom());
            }
            object = ((ECPrivateKeyParameters)this.f).getD();
            BigInteger bigInteger = this.d.getN().subtract(BigIntegers.ONE);
            if (((BigInteger)object).compareTo(ONE) < 0 || ((BigInteger)object).compareTo(bigInteger) >= 0) {
                throw new IllegalArgumentException("SM2 private key out of range");
            }
            this.e = this.createBasePointMultiplier().multiply(this.d.getG(), (BigInteger)object).normalize();
        } else {
            this.f = (ECKeyParameters)cipherParameters;
            this.d = this.f.getParameters();
            this.e = ((ECPublicKeyParameters)this.f).getQ();
        }
        CryptoServicesRegistrar.checkConstraints(com.enterprisedt.bouncycastle.crypto.signers.a.a("ECNR", this.f, forSigning));
        this.g = this.a(byArray);
        this.b.update(this.g, 0, this.g.length);
    }

    @Override
    public void update(byte b2) {
        this.b.update(b2);
    }

    @Override
    public void update(byte[] in, int off, int len) {
        this.b.update(in, off, len);
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        try {
            BigInteger[] bigIntegerArray = this.c.decode(this.d.getN(), signature);
            return this.a(bigIntegerArray[0], bigIntegerArray[1]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void reset() {
        this.b.reset();
        if (this.g != null) {
            this.b.update(this.g, 0, this.g.length);
        }
    }

    @Override
    public byte[] generateSignature() throws CryptoException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        byte[] byArray = this.a();
        BigInteger bigInteger3 = this.d.getN();
        BigInteger bigInteger4 = this.calculateE(bigInteger3, byArray);
        BigInteger bigInteger5 = ((ECPrivateKeyParameters)this.f).getD();
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        while (true) {
            BigInteger bigInteger6 = this.a.nextK();
            Object object = eCMultiplier.multiply(this.d.getG(), bigInteger6).normalize();
            bigInteger2 = bigInteger4.add(((ECPoint)object).getAffineXCoord().toBigInteger()).mod(bigInteger3);
            if (bigInteger2.equals(ZERO) || bigInteger2.add(bigInteger6).equals(bigInteger3)) continue;
            object = BigIntegers.modOddInverse(bigInteger3, bigInteger5.add(ONE));
            bigInteger = bigInteger6.subtract(bigInteger2.multiply(bigInteger5)).mod(bigInteger3);
            if (!(bigInteger = ((BigInteger)object).multiply(bigInteger).mod(bigInteger3)).equals(ZERO)) break;
        }
        try {
            return this.c.encode(this.d.getN(), bigInteger2, bigInteger);
        }
        catch (Exception exception) {
            throw new CryptoException("unable to encode signature: " + exception.getMessage(), exception);
        }
    }

    private boolean a(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = this.d.getN();
        if (bigInteger.compareTo(ONE) < 0 || bigInteger.compareTo(bigInteger3) >= 0) {
            return false;
        }
        if (bigInteger2.compareTo(ONE) < 0 || bigInteger2.compareTo(bigInteger3) >= 0) {
            return false;
        }
        byte[] byArray = this.a();
        BigInteger bigInteger4 = this.calculateE(bigInteger3, byArray);
        BigInteger bigInteger5 = bigInteger.add(bigInteger2).mod(bigInteger3);
        if (bigInteger5.equals(ZERO)) {
            return false;
        }
        ECPoint eCPoint = ((ECPublicKeyParameters)this.f).getQ();
        ECPoint eCPoint2 = ECAlgorithms.sumOfTwoMultiplies(this.d.getG(), bigInteger2, eCPoint, bigInteger5).normalize();
        if (eCPoint2.isInfinity()) {
            return false;
        }
        BigInteger bigInteger6 = bigInteger4.add(eCPoint2.getAffineXCoord().toBigInteger()).mod(bigInteger3);
        return bigInteger6.equals(bigInteger);
    }

    private byte[] a() {
        byte[] byArray = new byte[this.b.getDigestSize()];
        this.b.doFinal(byArray, 0);
        this.reset();
        return byArray;
    }

    private byte[] a(byte[] byArray) {
        this.b.reset();
        this.a(this.b, byArray);
        this.a(this.b, this.d.getCurve().getA());
        this.a(this.b, this.d.getCurve().getB());
        this.a(this.b, this.d.getG().getAffineXCoord());
        this.a(this.b, this.d.getG().getAffineYCoord());
        this.a(this.b, this.e.getAffineXCoord());
        this.a(this.b, this.e.getAffineYCoord());
        byte[] byArray2 = new byte[this.b.getDigestSize()];
        this.b.doFinal(byArray2, 0);
        return byArray2;
    }

    private void a(Digest digest, byte[] byArray) {
        int n2 = byArray.length * 8;
        digest.update((byte)(n2 >> 8 & 0xFF));
        digest.update((byte)(n2 & 0xFF));
        digest.update(byArray, 0, byArray.length);
    }

    private void a(Digest digest, ECFieldElement eCFieldElement) {
        byte[] byArray = eCFieldElement.getEncoded();
        digest.update(byArray, 0, byArray.length);
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    protected BigInteger calculateE(BigInteger n2, byte[] message) {
        return new BigInteger(1, message);
    }
}

