/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.util;

import com.enterprisedt.bouncycastle.crypto.AlphabetMapper;
import java.util.HashMap;
import java.util.Map;

public class BasicAlphabetMapper
implements AlphabetMapper {
    private Map<Character, Integer> a = new HashMap<Character, Integer>();
    private Map<Integer, Character> b = new HashMap<Integer, Character>();

    public BasicAlphabetMapper(String alphabet) {
        this(alphabet.toCharArray());
    }

    public BasicAlphabetMapper(char[] alphabet) {
        for (int i2 = 0; i2 != alphabet.length; ++i2) {
            if (this.a.containsKey(Character.valueOf(alphabet[i2]))) {
                throw new IllegalArgumentException("duplicate key detected in alphabet: " + alphabet[i2]);
            }
            this.a.put(Character.valueOf(alphabet[i2]), i2);
            this.b.put(i2, Character.valueOf(alphabet[i2]));
        }
    }

    @Override
    public int getRadix() {
        return this.a.size();
    }

    @Override
    public byte[] convertToIndexes(char[] input) {
        byte[] byArray;
        if (this.a.size() <= 256) {
            byArray = new byte[input.length];
            for (int i2 = 0; i2 != input.length; ++i2) {
                byArray[i2] = this.a.get(Character.valueOf(input[i2])).byteValue();
            }
        } else {
            byArray = new byte[input.length * 2];
            for (int i3 = 0; i3 != input.length; ++i3) {
                int n2 = this.a.get(Character.valueOf(input[i3]));
                byArray[i3 * 2] = (byte)(n2 >> 8 & 0xFF);
                byArray[i3 * 2 + 1] = (byte)(n2 & 0xFF);
            }
        }
        return byArray;
    }

    @Override
    public char[] convertToChars(byte[] input) {
        char[] cArray;
        if (this.b.size() <= 256) {
            cArray = new char[input.length];
            for (int i2 = 0; i2 != input.length; ++i2) {
                cArray[i2] = this.b.get(input[i2] & 0xFF).charValue();
            }
        } else {
            if ((input.length & 1) != 0) {
                throw new IllegalArgumentException("two byte radix and input string odd length");
            }
            cArray = new char[input.length / 2];
            for (int i3 = 0; i3 != input.length; i3 += 2) {
                cArray[i3 / 2] = this.b.get(input[i3] << 8 & 0xFF00 | input[i3 + 1] & 0xFF).charValue();
            }
        }
        return cArray;
    }
}

