/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.util;

import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.enterprisedt.bouncycastle.crypto.CipherKeyGenerator;
import com.enterprisedt.bouncycastle.crypto.KeyGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.generators.DESKeyGenerator;
import com.enterprisedt.bouncycastle.crypto.generators.DESedeKeyGenerator;
import com.enterprisedt.bouncycastle.crypto.util.AlgorithmIdentifierFactory;
import java.security.SecureRandom;

public class CipherKeyGeneratorFactory {
    private CipherKeyGeneratorFactory() {
    }

    public static CipherKeyGenerator createKeyGenerator(ASN1ObjectIdentifier algorithm, SecureRandom random) throws IllegalArgumentException {
        if (NISTObjectIdentifiers.id_aes128_CBC.equals(algorithm)) {
            return CipherKeyGeneratorFactory.a(random, 128);
        }
        if (NISTObjectIdentifiers.id_aes192_CBC.equals(algorithm)) {
            return CipherKeyGeneratorFactory.a(random, 192);
        }
        if (NISTObjectIdentifiers.id_aes256_CBC.equals(algorithm)) {
            return CipherKeyGeneratorFactory.a(random, 256);
        }
        if (NISTObjectIdentifiers.id_aes128_GCM.equals(algorithm)) {
            return CipherKeyGeneratorFactory.a(random, 128);
        }
        if (NISTObjectIdentifiers.id_aes192_GCM.equals(algorithm)) {
            return CipherKeyGeneratorFactory.a(random, 192);
        }
        if (NISTObjectIdentifiers.id_aes256_GCM.equals(algorithm)) {
            return CipherKeyGeneratorFactory.a(random, 256);
        }
        if (NISTObjectIdentifiers.id_aes128_CCM.equals(algorithm)) {
            return CipherKeyGeneratorFactory.a(random, 128);
        }
        if (NISTObjectIdentifiers.id_aes192_CCM.equals(algorithm)) {
            return CipherKeyGeneratorFactory.a(random, 192);
        }
        if (NISTObjectIdentifiers.id_aes256_CCM.equals(algorithm)) {
            return CipherKeyGeneratorFactory.a(random, 256);
        }
        if (PKCSObjectIdentifiers.des_EDE3_CBC.equals(algorithm)) {
            DESedeKeyGenerator dESedeKeyGenerator = new DESedeKeyGenerator();
            dESedeKeyGenerator.init(new KeyGenerationParameters(random, 192));
            return dESedeKeyGenerator;
        }
        if (NTTObjectIdentifiers.id_camellia128_cbc.equals(algorithm)) {
            return CipherKeyGeneratorFactory.a(random, 128);
        }
        if (NTTObjectIdentifiers.id_camellia192_cbc.equals(algorithm)) {
            return CipherKeyGeneratorFactory.a(random, 192);
        }
        if (NTTObjectIdentifiers.id_camellia256_cbc.equals(algorithm)) {
            return CipherKeyGeneratorFactory.a(random, 256);
        }
        if (KISAObjectIdentifiers.id_seedCBC.equals(algorithm)) {
            return CipherKeyGeneratorFactory.a(random, 128);
        }
        if (AlgorithmIdentifierFactory.b.equals(algorithm)) {
            return CipherKeyGeneratorFactory.a(random, 128);
        }
        if (OIWObjectIdentifiers.desCBC.equals(algorithm)) {
            DESKeyGenerator dESKeyGenerator = new DESKeyGenerator();
            dESKeyGenerator.init(new KeyGenerationParameters(random, 64));
            return dESKeyGenerator;
        }
        if (PKCSObjectIdentifiers.rc4.equals(algorithm)) {
            return CipherKeyGeneratorFactory.a(random, 128);
        }
        if (PKCSObjectIdentifiers.RC2_CBC.equals(algorithm)) {
            return CipherKeyGeneratorFactory.a(random, 128);
        }
        throw new IllegalArgumentException("cannot recognise cipher: " + algorithm);
    }

    private static CipherKeyGenerator a(SecureRandom secureRandom, int n2) {
        CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
        cipherKeyGenerator.init(new KeyGenerationParameters(secureRandom, n2));
        return cipherKeyGenerator;
    }
}

