/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.util;

import com.enterprisedt.bouncycastle.crypto.CryptoServicePurpose;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.digests.MD5Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA1Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA224Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA256Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA384Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA3Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA512Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA512tDigest;
import com.enterprisedt.bouncycastle.crypto.digests.SHAKEDigest;
import java.util.HashMap;
import java.util.Map;

public final class DigestFactory {
    private static final Map a = new HashMap();

    public static Digest createMD5() {
        return new MD5Digest();
    }

    public static Digest createMD5PRF() {
        return new MD5Digest();
    }

    public static Digest createSHA1() {
        return new SHA1Digest();
    }

    public static Digest createSHA1PRF() {
        return new SHA1Digest(CryptoServicePurpose.PRF);
    }

    public static Digest createSHA224() {
        return new SHA224Digest();
    }

    public static Digest createSHA224PRF() {
        return new SHA224Digest(CryptoServicePurpose.PRF);
    }

    public static Digest createSHA256() {
        return SHA256Digest.newInstance();
    }

    public static Digest createSHA256PRF() {
        return new SHA256Digest(CryptoServicePurpose.PRF);
    }

    public static Digest createSHA384() {
        return new SHA384Digest();
    }

    public static Digest createSHA384PRF() {
        return new SHA384Digest(CryptoServicePurpose.PRF);
    }

    public static Digest createSHA512() {
        return new SHA512Digest();
    }

    public static Digest createSHA512PRF() {
        return new SHA512Digest(CryptoServicePurpose.PRF);
    }

    public static Digest createSHA512_224() {
        return new SHA512tDigest(224);
    }

    public static Digest createSHA512_224PRF() {
        return new SHA512tDigest(224, CryptoServicePurpose.PRF);
    }

    public static Digest createSHA512_256() {
        return new SHA512tDigest(256);
    }

    public static Digest createSHA512_256PRF() {
        return new SHA512tDigest(256, CryptoServicePurpose.PRF);
    }

    public static Digest createSHA3_224() {
        return new SHA3Digest(224);
    }

    public static Digest createSHA3_224PRF() {
        return new SHA3Digest(224, CryptoServicePurpose.PRF);
    }

    public static Digest createSHA3_256() {
        return new SHA3Digest(256);
    }

    public static Digest createSHA3_256PRF() {
        return new SHA3Digest(256, CryptoServicePurpose.PRF);
    }

    public static Digest createSHA3_384() {
        return new SHA3Digest(384);
    }

    public static Digest createSHA3_384PRF() {
        return new SHA3Digest(384, CryptoServicePurpose.PRF);
    }

    public static Digest createSHA3_512() {
        return new SHA3Digest(512);
    }

    public static Digest createSHA3_512PRF() {
        return new SHA3Digest(512, CryptoServicePurpose.PRF);
    }

    public static Digest createSHAKE128() {
        return new SHAKEDigest(128);
    }

    public static Digest createSHAKE256() {
        return new SHAKEDigest(256);
    }

    public static Digest cloneDigest(Digest hashAlg) {
        return ((a)a.get(hashAlg.getAlgorithmName())).a(hashAlg);
    }

    static {
        a.put(DigestFactory.createMD5().getAlgorithmName(), new a(){

            @Override
            public Digest a(Digest digest) {
                return new MD5Digest((MD5Digest)digest);
            }
        });
        a.put(DigestFactory.createSHA1().getAlgorithmName(), new a(){

            @Override
            public Digest a(Digest digest) {
                return new MD5Digest((MD5Digest)digest);
            }
        });
        a.put(DigestFactory.createSHA224().getAlgorithmName(), new a(){

            @Override
            public Digest a(Digest digest) {
                return new SHA224Digest((SHA224Digest)digest);
            }
        });
        a.put(DigestFactory.createSHA256().getAlgorithmName(), new a(){

            @Override
            public Digest a(Digest digest) {
                return SHA256Digest.newInstance(digest);
            }
        });
        a.put(DigestFactory.createSHA384().getAlgorithmName(), new a(){

            @Override
            public Digest a(Digest digest) {
                return new SHA384Digest((SHA384Digest)digest);
            }
        });
        a.put(DigestFactory.createSHA512().getAlgorithmName(), new a(){

            @Override
            public Digest a(Digest digest) {
                return new SHA512Digest((SHA512Digest)digest);
            }
        });
        a.put(DigestFactory.createSHA3_224().getAlgorithmName(), new a(){

            @Override
            public Digest a(Digest digest) {
                return new SHA3Digest((SHA3Digest)digest);
            }
        });
        a.put(DigestFactory.createSHA3_256().getAlgorithmName(), new a(){

            @Override
            public Digest a(Digest digest) {
                return new SHA3Digest((SHA3Digest)digest);
            }
        });
        a.put(DigestFactory.createSHA3_384().getAlgorithmName(), new a(){

            @Override
            public Digest a(Digest digest) {
                return new SHA3Digest((SHA3Digest)digest);
            }
        });
        a.put(DigestFactory.createSHA3_512().getAlgorithmName(), new a(){

            @Override
            public Digest a(Digest digest) {
                return new SHA3Digest((SHA3Digest)digest);
            }
        });
        a.put(DigestFactory.createSHAKE128().getAlgorithmName(), new a(){

            @Override
            public Digest a(Digest digest) {
                return new SHAKEDigest((SHAKEDigest)digest);
            }
        });
        a.put(DigestFactory.createSHAKE256().getAlgorithmName(), new a(){

            @Override
            public Digest a(Digest digest) {
                return new SHAKEDigest((SHAKEDigest)digest);
            }
        });
    }

    private static interface a {
        public Digest a(Digest var1);
    }
}

