/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.util;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.util.JournalingSecureRandom;
import com.enterprisedt.bouncycastle.util.Encodable;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.SecureRandom;

public class JournaledAlgorithm
implements Encodable,
Serializable {
    private transient JournalingSecureRandom a;
    private transient AlgorithmIdentifier b;

    public JournaledAlgorithm(AlgorithmIdentifier aid, JournalingSecureRandom journaling) {
        if (aid == null) {
            throw new NullPointerException("AlgorithmIdentifier passed to JournaledAlgorithm is null");
        }
        if (journaling == null) {
            throw new NullPointerException("JournalingSecureRandom passed to JournaledAlgorithm is null");
        }
        this.a = journaling;
        this.b = aid;
    }

    public JournaledAlgorithm(byte[] encoding) {
        this(encoding, CryptoServicesRegistrar.getSecureRandom());
    }

    public JournaledAlgorithm(byte[] encoding, SecureRandom random) {
        if (encoding == null) {
            throw new NullPointerException("encoding passed to JournaledAlgorithm is null");
        }
        if (random == null) {
            throw new NullPointerException("random passed to JournaledAlgorithm is null");
        }
        this.a(encoding, random);
    }

    private void a(byte[] byArray, SecureRandom secureRandom) {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(byArray);
        this.b = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        this.a = new JournalingSecureRandom(ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(1)).getOctets(), secureRandom);
    }

    public JournalingSecureRandom getJournalingSecureRandom() {
        return this.a;
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.b;
    }

    public void storeState(File tempfile) throws IOException {
        if (tempfile == null) {
            throw new NullPointerException("file for storage is null in JournaledAlgorithm");
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(tempfile);){
            this.storeState(fileOutputStream);
        }
    }

    public void storeState(OutputStream out) throws IOException {
        if (out == null) {
            throw new NullPointerException("output stream for storage is null in JournaledAlgorithm");
        }
        out.write(this.getEncoded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JournaledAlgorithm getState(InputStream stateIn, SecureRandom random) throws IOException, ClassNotFoundException {
        if (stateIn == null) {
            throw new NullPointerException("stream for loading is null in JournaledAlgorithm");
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(stateIn);){
            JournaledAlgorithm journaledAlgorithm = new JournaledAlgorithm(Streams.readAll(bufferedInputStream), random);
            return journaledAlgorithm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JournaledAlgorithm getState(File tempfile, SecureRandom random) throws IOException, ClassNotFoundException {
        if (tempfile == null) {
            throw new NullPointerException("File for loading is null in JournaledAlgorithm");
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(tempfile));){
            JournaledAlgorithm journaledAlgorithm = new JournaledAlgorithm(Streams.readAll(bufferedInputStream), random);
            return journaledAlgorithm;
        }
    }

    @Override
    public byte[] getEncoded() throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(new DEROctetString(this.a.getFullTranscript()));
        return new DERSequence(aSN1EncodableVector).getEncoded();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.a((byte[])in.readObject(), CryptoServicesRegistrar.getSecureRandom());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

