/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.util;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.nist.NISTNamedCurves;
import com.enterprisedt.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.enterprisedt.bouncycastle.asn1.pkcs.RSAPrivateKey;
import com.enterprisedt.bouncycastle.asn1.sec.ECPrivateKey;
import com.enterprisedt.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.DSAParameters;
import com.enterprisedt.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.enterprisedt.bouncycastle.crypto.util.OpenSSHPublicKeyUtil;
import com.enterprisedt.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import com.enterprisedt.bouncycastle.crypto.util.SSHNamedCurves;
import com.enterprisedt.bouncycastle.crypto.util.b;
import com.enterprisedt.bouncycastle.crypto.util.c;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import com.enterprisedt.bouncycastle.util.Strings;
import java.io.IOException;
import java.math.BigInteger;

public class OpenSSHPrivateKeyUtil {
    static final byte[] a = Strings.toByteArray("openssh-key-v1\u0000");

    private OpenSSHPrivateKeyUtil() {
    }

    public static byte[] encodePrivateKey(AsymmetricKeyParameter params) throws IOException {
        if (params == null) {
            throw new IllegalArgumentException("param is null");
        }
        if (params instanceof RSAPrivateCrtKeyParameters) {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(params);
            return privateKeyInfo.parsePrivateKey().toASN1Primitive().getEncoded();
        }
        if (params instanceof ECPrivateKeyParameters) {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(params);
            return privateKeyInfo.parsePrivateKey().toASN1Primitive().getEncoded();
        }
        if (params instanceof DSAPrivateKeyParameters) {
            DSAPrivateKeyParameters dSAPrivateKeyParameters = (DSAPrivateKeyParameters)params;
            DSAParameters dSAParameters = dSAPrivateKeyParameters.getParameters();
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add(new ASN1Integer(0L));
            aSN1EncodableVector.add(new ASN1Integer(dSAParameters.getP()));
            aSN1EncodableVector.add(new ASN1Integer(dSAParameters.getQ()));
            aSN1EncodableVector.add(new ASN1Integer(dSAParameters.getG()));
            BigInteger bigInteger = dSAParameters.getG().modPow(dSAPrivateKeyParameters.getX(), dSAParameters.getP());
            aSN1EncodableVector.add(new ASN1Integer(bigInteger));
            aSN1EncodableVector.add(new ASN1Integer(dSAPrivateKeyParameters.getX()));
            try {
                return new DERSequence(aSN1EncodableVector).getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("unable to encode DSAPrivateKeyParameters " + exception.getMessage());
            }
        }
        if (params instanceof Ed25519PrivateKeyParameters) {
            Ed25519PublicKeyParameters ed25519PublicKeyParameters = ((Ed25519PrivateKeyParameters)params).generatePublicKey();
            c c2 = new c();
            c2.b(a);
            c2.a("none");
            c2.a("none");
            c2.a("");
            c2.a(1);
            Object object = OpenSSHPublicKeyUtil.encodePublicKey(ed25519PublicKeyParameters);
            c2.a((byte[])object);
            object = new c();
            int n2 = CryptoServicesRegistrar.getSecureRandom().nextInt();
            ((c)object).a(n2);
            ((c)object).a(n2);
            ((c)object).a("ssh-ed25519");
            byte[] byArray = ed25519PublicKeyParameters.getEncoded();
            ((c)object).a(byArray);
            ((c)object).a(Arrays.concatenate(((Ed25519PrivateKeyParameters)params).getEncoded(), byArray));
            ((c)object).a("");
            c2.a(((c)object).b());
            return c2.a();
        }
        throw new IllegalArgumentException("unable to convert " + params.getClass().getName() + " to openssh private key");
    }

    public static AsymmetricKeyParameter parsePrivateKeyBlob(byte[] blob) {
        AsymmetricKeyParameter asymmetricKeyParameter = null;
        if (blob[0] == 48) {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(blob);
            if (aSN1Sequence.size() == 6) {
                if (OpenSSHPrivateKeyUtil.a(aSN1Sequence) && ((ASN1Integer)aSN1Sequence.getObjectAt(0)).getPositiveValue().equals(BigIntegers.ZERO)) {
                    asymmetricKeyParameter = new DSAPrivateKeyParameters(((ASN1Integer)aSN1Sequence.getObjectAt(5)).getPositiveValue(), new DSAParameters(((ASN1Integer)aSN1Sequence.getObjectAt(1)).getPositiveValue(), ((ASN1Integer)aSN1Sequence.getObjectAt(2)).getPositiveValue(), ((ASN1Integer)aSN1Sequence.getObjectAt(3)).getPositiveValue()));
                }
            } else if (aSN1Sequence.size() == 9) {
                if (OpenSSHPrivateKeyUtil.a(aSN1Sequence) && ((ASN1Integer)aSN1Sequence.getObjectAt(0)).getPositiveValue().equals(BigIntegers.ZERO)) {
                    RSAPrivateKey rSAPrivateKey = RSAPrivateKey.getInstance(aSN1Sequence);
                    asymmetricKeyParameter = new RSAPrivateCrtKeyParameters(rSAPrivateKey.getModulus(), rSAPrivateKey.getPublicExponent(), rSAPrivateKey.getPrivateExponent(), rSAPrivateKey.getPrime1(), rSAPrivateKey.getPrime2(), rSAPrivateKey.getExponent1(), rSAPrivateKey.getExponent2(), rSAPrivateKey.getCoefficient());
                }
            } else if (aSN1Sequence.size() == 4 && aSN1Sequence.getObjectAt(3) instanceof ASN1TaggedObject && aSN1Sequence.getObjectAt(2) instanceof ASN1TaggedObject) {
                ECPrivateKey eCPrivateKey = ECPrivateKey.getInstance(aSN1Sequence);
                ASN1ObjectIdentifier aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance(eCPrivateKey.getParametersObject());
                X9ECParameters x9ECParameters = ECNamedCurveTable.getByOID(aSN1ObjectIdentifier);
                asymmetricKeyParameter = new ECPrivateKeyParameters(eCPrivateKey.getKey(), (ECDomainParameters)new ECNamedDomainParameters(aSN1ObjectIdentifier, x9ECParameters));
            }
        } else {
            int n2;
            b b2 = new b(a, blob);
            String string = b2.b();
            if (!"none".equals(string)) {
                throw new IllegalStateException("encrypted keys not supported");
            }
            b2.d();
            b2.d();
            int n3 = b2.a();
            if (n3 != 1) {
                throw new IllegalStateException("multiple keys not supported");
            }
            OpenSSHPublicKeyUtil.parsePublicKey(b2.c());
            byte[] byArray = b2.e();
            if (b2.g()) {
                throw new IllegalArgumentException("decoded key has trailing data");
            }
            b b3 = new b(byArray);
            int n4 = b3.a();
            if (n4 != (n2 = b3.a())) {
                throw new IllegalStateException("private key check values are not the same");
            }
            String string2 = b3.b();
            if ("ssh-ed25519".equals(string2)) {
                b3.c();
                byte[] byArray2 = b3.c();
                if (byArray2.length != 64) {
                    throw new IllegalStateException("private key value of wrong length");
                }
                asymmetricKeyParameter = new Ed25519PrivateKeyParameters(byArray2, 0);
            } else if (string2.startsWith("ecdsa")) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = SSHNamedCurves.getByName(Strings.fromByteArray(b3.c()));
                if (aSN1ObjectIdentifier == null) {
                    throw new IllegalStateException("OID not found for: " + string2);
                }
                X9ECParameters x9ECParameters = NISTNamedCurves.getByOID(aSN1ObjectIdentifier);
                if (x9ECParameters == null) {
                    throw new IllegalStateException("Curve not found for: " + aSN1ObjectIdentifier);
                }
                b3.c();
                byte[] byArray3 = b3.c();
                asymmetricKeyParameter = new ECPrivateKeyParameters(new BigInteger(1, byArray3), (ECDomainParameters)new ECNamedDomainParameters(aSN1ObjectIdentifier, x9ECParameters));
            } else if (string2.startsWith("ssh-rsa")) {
                BigInteger bigInteger = new BigInteger(1, b3.c());
                BigInteger bigInteger2 = new BigInteger(1, b3.c());
                BigInteger bigInteger3 = new BigInteger(1, b3.c());
                BigInteger bigInteger4 = new BigInteger(1, b3.c());
                BigInteger bigInteger5 = new BigInteger(1, b3.c());
                BigInteger bigInteger6 = new BigInteger(1, b3.c());
                BigInteger bigInteger7 = bigInteger5.subtract(BigIntegers.ONE);
                BigInteger bigInteger8 = bigInteger6.subtract(BigIntegers.ONE);
                BigInteger bigInteger9 = bigInteger3.remainder(bigInteger7);
                BigInteger bigInteger10 = bigInteger3.remainder(bigInteger8);
                asymmetricKeyParameter = new RSAPrivateCrtKeyParameters(bigInteger, bigInteger2, bigInteger3, bigInteger5, bigInteger6, bigInteger9, bigInteger10, bigInteger4);
            }
            b3.d();
            if (b3.g()) {
                throw new IllegalArgumentException("private key block has trailing data");
            }
        }
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("unable to parse key");
        }
        return asymmetricKeyParameter;
    }

    private static boolean a(ASN1Sequence aSN1Sequence) {
        for (int i2 = 0; i2 < aSN1Sequence.size(); ++i2) {
            if (aSN1Sequence.getObjectAt(i2) instanceof ASN1Integer) continue;
            return false;
        }
        return true;
    }
}

