/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.util;

import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECParameters;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.DSAParameters;
import com.enterprisedt.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.crypto.util.SSHNamedCurves;
import com.enterprisedt.bouncycastle.crypto.util.b;
import com.enterprisedt.bouncycastle.crypto.util.c;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import java.io.IOException;
import java.math.BigInteger;

public class OpenSSHPublicKeyUtil {
    private OpenSSHPublicKeyUtil() {
    }

    public static AsymmetricKeyParameter parsePublicKey(byte[] encoded) {
        b b2 = new b(encoded);
        return OpenSSHPublicKeyUtil.parsePublicKey(b2);
    }

    public static byte[] encodePublicKey(AsymmetricKeyParameter cipherParameters) throws IOException {
        if (cipherParameters == null) {
            throw new IllegalArgumentException("cipherParameters was null.");
        }
        if (cipherParameters instanceof RSAKeyParameters) {
            if (cipherParameters.isPrivate()) {
                throw new IllegalArgumentException("RSAKeyParamaters was for encryption");
            }
            RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)cipherParameters;
            c c2 = new c();
            c2.a("ssh-rsa");
            c2.a(rSAKeyParameters.getExponent());
            c2.a(rSAKeyParameters.getModulus());
            return c2.a();
        }
        if (cipherParameters instanceof ECPublicKeyParameters) {
            c c3 = new c();
            String string = SSHNamedCurves.getNameForParameters(((ECPublicKeyParameters)cipherParameters).getParameters());
            if (string == null) {
                throw new IllegalArgumentException("unable to derive ssh curve name for " + ((ECPublicKeyParameters)cipherParameters).getParameters().getCurve().getClass().getName());
            }
            c3.a("ecdsa-sha2-" + string);
            c3.a(string);
            c3.a(((ECPublicKeyParameters)cipherParameters).getQ().getEncoded(false));
            return c3.a();
        }
        if (cipherParameters instanceof DSAPublicKeyParameters) {
            DSAPublicKeyParameters dSAPublicKeyParameters = (DSAPublicKeyParameters)cipherParameters;
            DSAParameters dSAParameters = dSAPublicKeyParameters.getParameters();
            c c4 = new c();
            c4.a("ssh-dss");
            c4.a(dSAParameters.getP());
            c4.a(dSAParameters.getQ());
            c4.a(dSAParameters.getG());
            c4.a(dSAPublicKeyParameters.getY());
            return c4.a();
        }
        if (cipherParameters instanceof Ed25519PublicKeyParameters) {
            c c5 = new c();
            c5.a("ssh-ed25519");
            c5.a(((Ed25519PublicKeyParameters)cipherParameters).getEncoded());
            return c5.a();
        }
        throw new IllegalArgumentException("unable to convert " + cipherParameters.getClass().getName() + " to public key");
    }

    public static AsymmetricKeyParameter parsePublicKey(b buffer) {
        AsymmetricKeyParameter asymmetricKeyParameter = null;
        String string = buffer.b();
        if ("ssh-rsa".equals(string)) {
            BigInteger bigInteger = buffer.f();
            BigInteger bigInteger2 = buffer.f();
            asymmetricKeyParameter = new RSAKeyParameters(false, bigInteger2, bigInteger);
        } else if ("ssh-dss".equals(string)) {
            BigInteger bigInteger = buffer.f();
            BigInteger bigInteger3 = buffer.f();
            BigInteger bigInteger4 = buffer.f();
            BigInteger bigInteger5 = buffer.f();
            asymmetricKeyParameter = new DSAPublicKeyParameters(bigInteger5, new DSAParameters(bigInteger, bigInteger3, bigInteger4));
        } else if (string.startsWith("ecdsa")) {
            String string2 = buffer.b();
            ASN1ObjectIdentifier aSN1ObjectIdentifier = SSHNamedCurves.getByName(string2);
            X9ECParameters x9ECParameters = SSHNamedCurves.getParameters(aSN1ObjectIdentifier);
            if (x9ECParameters == null) {
                throw new IllegalStateException("unable to find curve for " + string + " using curve name " + string2);
            }
            ECCurve eCCurve = x9ECParameters.getCurve();
            byte[] byArray = buffer.c();
            asymmetricKeyParameter = new ECPublicKeyParameters(eCCurve.decodePoint(byArray), (ECDomainParameters)new ECNamedDomainParameters(aSN1ObjectIdentifier, x9ECParameters));
        } else if ("ssh-ed25519".equals(string)) {
            byte[] byArray = buffer.c();
            if (byArray.length != 32) {
                throw new IllegalStateException("public key value of wrong length");
            }
            asymmetricKeyParameter = new Ed25519PublicKeyParameters(byArray, 0);
        }
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("unable to parse key");
        }
        if (buffer.g()) {
            throw new IllegalArgumentException("decoded key has trailing data");
        }
        return asymmetricKeyParameter;
    }
}

