/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.util;

import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.nist.NISTNamedCurves;
import com.enterprisedt.bouncycastle.asn1.sec.SECObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECParameters;
import com.enterprisedt.bouncycastle.crypto.ec.CustomNamedCurves;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.util.Strings;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class SSHNamedCurves {
    private static final Map<ASN1ObjectIdentifier, String> a;
    private static final Map<String, ASN1ObjectIdentifier> b;
    private static final Map<String, String> c;
    private static HashMap<ECCurve, String> d;

    public static ASN1ObjectIdentifier getByName(String sshName) {
        return b.get(sshName);
    }

    public static X9ECParameters getParameters(String sshName) {
        return NISTNamedCurves.getByOID(b.get(Strings.toLowerCase(sshName)));
    }

    public static X9ECParameters getParameters(ASN1ObjectIdentifier oid) {
        return NISTNamedCurves.getByOID(oid);
    }

    public static String getName(ASN1ObjectIdentifier oid) {
        return a.get(oid);
    }

    public static String getNameForParameters(ECDomainParameters parameters) {
        if (parameters instanceof ECNamedDomainParameters) {
            return SSHNamedCurves.getName(((ECNamedDomainParameters)parameters).getName());
        }
        return SSHNamedCurves.getNameForParameters(parameters.getCurve());
    }

    public static String getNameForParameters(ECCurve curve) {
        return c.get(d.get(curve));
    }

    static {
        b = Collections.unmodifiableMap(new HashMap<String, ASN1ObjectIdentifier>(){
            {
                this.put("nistp256", SECObjectIdentifiers.secp256r1);
                this.put("nistp384", SECObjectIdentifiers.secp384r1);
                this.put("nistp521", SECObjectIdentifiers.secp521r1);
                this.put("nistk163", SECObjectIdentifiers.sect163k1);
                this.put("nistp192", SECObjectIdentifiers.secp192r1);
                this.put("nistp224", SECObjectIdentifiers.secp224r1);
                this.put("nistk233", SECObjectIdentifiers.sect233k1);
                this.put("nistb233", SECObjectIdentifiers.sect233r1);
                this.put("nistk283", SECObjectIdentifiers.sect283k1);
                this.put("nistk409", SECObjectIdentifiers.sect409k1);
                this.put("nistb409", SECObjectIdentifiers.sect409r1);
                this.put("nistt571", SECObjectIdentifiers.sect571k1);
            }
        });
        c = Collections.unmodifiableMap(new HashMap<String, String>(){
            {
                String[][] stringArrayArray = new String[][]{{"secp256r1", "nistp256"}, {"secp384r1", "nistp384"}, {"secp521r1", "nistp521"}, {"sect163k1", "nistk163"}, {"secp192r1", "nistp192"}, {"secp224r1", "nistp224"}, {"sect233k1", "nistk233"}, {"sect233r1", "nistb233"}, {"sect283k1", "nistk283"}, {"sect409k1", "nistk409"}, {"sect409r1", "nistb409"}, {"sect571k1", "nistt571"}};
                for (int i2 = 0; i2 != stringArrayArray.length; ++i2) {
                    String[] stringArray = stringArrayArray[i2];
                    this.put(stringArray[0], stringArray[1]);
                }
            }
        });
        d = new HashMap<ECCurve, String>(){
            {
                Enumeration enumeration = CustomNamedCurves.getNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    ECCurve eCCurve = CustomNamedCurves.getByNameLazy(string).getCurve();
                    this.put(eCCurve, string);
                }
            }
        };
        a = Collections.unmodifiableMap(new HashMap<ASN1ObjectIdentifier, String>(){
            {
                for (String string : b.keySet()) {
                    this.put(b.get(string), string);
                }
            }
        });
    }
}

