/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.util;

import com.enterprisedt.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import com.enterprisedt.bouncycastle.crypto.util.PBKDFConfig;

public class ScryptConfig
extends PBKDFConfig {
    private final int a;
    private final int b;
    private final int c;
    private final int d;

    private ScryptConfig(Builder builder) {
        super(MiscObjectIdentifiers.id_scrypt);
        this.a = builder.a;
        this.b = builder.b;
        this.c = builder.c;
        this.d = builder.d;
    }

    public int getCostParameter() {
        return this.a;
    }

    public int getBlockSize() {
        return this.b;
    }

    public int getParallelizationParameter() {
        return this.c;
    }

    public int getSaltLength() {
        return this.d;
    }

    public static class Builder {
        private final int a;
        private final int b;
        private final int c;
        private int d = 16;

        public Builder(int costParameter, int blockSize, int parallelizationParameter) {
            if (costParameter <= 1 || !Builder.a(costParameter)) {
                throw new IllegalArgumentException("Cost parameter N must be > 1 and a power of 2");
            }
            this.a = costParameter;
            this.b = blockSize;
            this.c = parallelizationParameter;
        }

        public Builder withSaltLength(int saltLength) {
            this.d = saltLength;
            return this;
        }

        public ScryptConfig build() {
            return new ScryptConfig(this);
        }

        private static boolean a(int n2) {
            return (n2 & n2 - 1) == 0;
        }
    }
}

