/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.util;

import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.DERNull;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.enterprisedt.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.pkcs.RSAPublicKey;
import com.enterprisedt.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.DSAParameter;
import com.enterprisedt.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.enterprisedt.bouncycastle.asn1.x9.X962Parameters;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECParameters;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECPoint;
import com.enterprisedt.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.DSAParameters;
import com.enterprisedt.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECGOST3410Parameters;
import com.enterprisedt.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.X25519PublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.X448PublicKeyParameters;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public class SubjectPublicKeyInfoFactory {
    private static Set a = new HashSet(5);

    private SubjectPublicKeyInfoFactory() {
    }

    public static SubjectPublicKeyInfo createSubjectPublicKeyInfo(AsymmetricKeyParameter publicKey) throws IOException {
        if (publicKey instanceof RSAKeyParameters) {
            RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)publicKey;
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), new RSAPublicKey(rSAKeyParameters.getModulus(), rSAKeyParameters.getExponent()));
        }
        if (publicKey instanceof DSAPublicKeyParameters) {
            DSAPublicKeyParameters dSAPublicKeyParameters = (DSAPublicKeyParameters)publicKey;
            DSAParameter dSAParameter = null;
            DSAParameters dSAParameters = dSAPublicKeyParameters.getParameters();
            if (dSAParameters != null) {
                dSAParameter = new DSAParameter(dSAParameters.getP(), dSAParameters.getQ(), dSAParameters.getG());
            }
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, dSAParameter), new ASN1Integer(dSAPublicKeyParameters.getY()));
        }
        if (publicKey instanceof ECPublicKeyParameters) {
            Object object;
            X962Parameters x962Parameters;
            ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)publicKey;
            ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
            if (eCDomainParameters == null) {
                x962Parameters = new X962Parameters(DERNull.INSTANCE);
            } else {
                if (eCDomainParameters instanceof ECGOST3410Parameters) {
                    ASN1ObjectIdentifier aSN1ObjectIdentifier;
                    int n2;
                    int n3;
                    ECGOST3410Parameters eCGOST3410Parameters = (ECGOST3410Parameters)eCDomainParameters;
                    BigInteger bigInteger = eCPublicKeyParameters.getQ().getAffineXCoord().toBigInteger();
                    BigInteger bigInteger2 = eCPublicKeyParameters.getQ().getAffineYCoord().toBigInteger();
                    GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters = new GOST3410PublicKeyAlgParameters(eCGOST3410Parameters.getPublicKeyParamSet(), eCGOST3410Parameters.getDigestParamSet());
                    if (a.contains(eCGOST3410Parameters.getPublicKeyParamSet())) {
                        n3 = 64;
                        n2 = 32;
                        aSN1ObjectIdentifier = CryptoProObjectIdentifiers.gostR3410_2001;
                    } else {
                        boolean bl;
                        boolean bl2 = bl = bigInteger.bitLength() > 256;
                        if (bl) {
                            n3 = 128;
                            n2 = 64;
                            aSN1ObjectIdentifier = RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512;
                        } else {
                            n3 = 64;
                            n2 = 32;
                            aSN1ObjectIdentifier = RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256;
                        }
                    }
                    byte[] byArray = new byte[n3];
                    SubjectPublicKeyInfoFactory.a(byArray, n3 / 2, 0, bigInteger);
                    SubjectPublicKeyInfoFactory.a(byArray, n3 / 2, n2, bigInteger2);
                    try {
                        return new SubjectPublicKeyInfo(new AlgorithmIdentifier(aSN1ObjectIdentifier, gOST3410PublicKeyAlgParameters), new DEROctetString(byArray));
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
                if (eCDomainParameters instanceof ECNamedDomainParameters) {
                    x962Parameters = new X962Parameters(((ECNamedDomainParameters)eCDomainParameters).getName());
                } else {
                    object = new X9ECParameters(eCDomainParameters.getCurve(), new X9ECPoint(eCDomainParameters.getG(), false), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
                    x962Parameters = new X962Parameters((X9ECParameters)object);
                }
            }
            object = eCPublicKeyParameters.getQ().getEncoded(false);
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), (byte[])object);
        }
        if (publicKey instanceof X448PublicKeyParameters) {
            X448PublicKeyParameters x448PublicKeyParameters = (X448PublicKeyParameters)publicKey;
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X448), x448PublicKeyParameters.getEncoded());
        }
        if (publicKey instanceof X25519PublicKeyParameters) {
            X25519PublicKeyParameters x25519PublicKeyParameters = (X25519PublicKeyParameters)publicKey;
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X25519), x25519PublicKeyParameters.getEncoded());
        }
        if (publicKey instanceof Ed448PublicKeyParameters) {
            Ed448PublicKeyParameters ed448PublicKeyParameters = (Ed448PublicKeyParameters)publicKey;
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed448), ed448PublicKeyParameters.getEncoded());
        }
        if (publicKey instanceof Ed25519PublicKeyParameters) {
            Ed25519PublicKeyParameters ed25519PublicKeyParameters = (Ed25519PublicKeyParameters)publicKey;
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), ed25519PublicKeyParameters.getEncoded());
        }
        throw new IOException("key parameters not recognized");
    }

    private static void a(byte[] byArray, int n2, int n3, BigInteger bigInteger) {
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length < n2) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
            byArray2 = byArray3;
        }
        for (int i2 = 0; i2 != n2; ++i2) {
            byArray[n3 + i2] = byArray2[byArray2.length - 1 - i2];
        }
    }

    static {
        a.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_A);
        a.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_B);
        a.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_C);
        a.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_XchA);
        a.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_XchB);
    }
}

